--- @class Function

Function = {}

---函数用于检查一个对象是否是可调用的。如果返回 True, object 仍然可能调用失败；但如果返回 False, 调用对象 object 绝对不会成功。
---对于函数、方法、lambda 函式、 类以及实现了 __call 方法的类实例, 它都返回 True。
---
---@eve_version 1.0.0
---@generic T
---@param object T
---@return boolean
function Function:callable(object)
    local lua_type = type(object)
    if lua_type == "function" then
        return true
    end
    if lua_type == "table" then
        local meta = getmetatable(x)
        return type(meta.__call) == "function" 
    end

    return false
end

return Function