--- @class Dict

List = require 'EveLuaKit.list'

Dict = {}

--- 创建并返回一个新的Dict字典
--- 
--- @eve_version 1.0
--- @param  const_dict table
--- @return Dict
function Dict:new(const_dict)
    local result = {}
    result._data = {}
    result._is_dict = true
    
    if const_dict ~= nil then
        for k, v in pairs(const_dict) do
            result._data[k] = v
        end
    end

    result.key_index = nil
    setmetatable(result, {
        __index = function(self, index)
            if self._data[index] ~= nil then
                return self._data[index]
            end
            return Dict[index]
        end,
        __newindex = function(self, index, value)
            self._data[index] = value
        end,
        __call = function(self, _, idx)
            if idx == nil and self.key_index ~= nil then
                self.key_index = nil
            end

            self.key_index, _ = next(self._data, self.key_index)

            return self.key_index
        end,
    })
    return result
end

--- 清除Dict所有的数据
--- 
--- @eve_version 1.0
--- @return nil
function Dict:clear()
    self._data = {}
end

--- 深拷贝并返回一个Dict
--- 
--- @eve_version 1.0
--- @return Dict
function Dict:copy()
    return Dict(self._data)
end

--- 获取Dict指定key的值, 当key不存在时使用默认值default
--- 
--- @eve_version 1.0
--- @generic T
--- @param key string
--- @param default T
--- @return Dict
function Dict:get(key, default)
    default = default or nil
    if self._data[key] == nil then
        return default
    end

    return self._data[key]
end

--- 返回可遍历的(键, 值) 元组数组的迭代器
--- 
--- @eve_version 1.0
--- @param key string
--- @param default T
--- @return fun(table: table<K, V>):K, V
function Dict:items()
    return pairs(self._data)
end

---返回字典的所有key组成的数组
---
--- @eve_version 1.0
--- @return List
function Dict:keys()
    local keys = List:new({})
    for key, value in pairs(self._data) do
        keys:append(key)
    end
    return keys
end

---返回字典的所有value组成的数组
---
--- @eve_version 1.0
--- @return List
function Dict:values()
    local values = List:new({})
    for key, value in pairs(self._data) do
        values:append(value)
    end
    return values
end

--- 移除并返回Dict指定key的值, 当key不存在时使用默认值default
--- 
--- @eve_version 1.0
--- @generic T
--- @param key string
--- @param default T
--- @return T
function Dict:pop(key, default)
    default = default or nil
    if self._data[key] ~= nil then
        local value = self._data[key]
        self._data[key] = nil
        return key, value
    end

    return key, default
end

--- 返回并删除字典中的最后一对键和值
--- 
--- @eve_version 1.0
--- @return string, T
function Dict:popitem()
    local key, value = next(self._data)
    if key ~= nil then
        self._data[key] = nil
    end

    return key, value
end

--- 把另一个字典dict的键/值对更新到当前字典里
--- 
--- @eve_version 1.0
--- @param dict Dict
function Dict:update(dict)
    assert(t._is_Dict)

    for k, v in t.items() do
        self._data[k] = v
    end
end
return Dict