from enum import Enum
from EvePythonKit.NativeBridge import NativeBridge

XGB = "XGB"
NN = "NN"

class KNN(object):
  def __init__(self, modelPath: str, modelType: str, needCache: bool = False) -> None:
    self.modelPath = modelPath
    self.modelType = modelType
    self.needCache = needCache

  def predict(self, input) -> list:
    return NativeBridge.kNNPredict(input, self.modelPath, self.modelType, self.needCache)
