def generate_sql_query(job: dict):
    # 处理 calculates 部分
    calculate_clauses = []

    if 'calculates' in job:
        calculate_list = job['calculates']
    elif 'calculate' in job:
        calculate_list = [job['calculate']]

    for calculate_item in calculate_list:
      calculate_op = calculate_item['op']
      calculate_keys = calculate_item.get("keys", ["all"])
      calculate_keys_clauses = []
      for key in calculate_keys:
        calculate_keys_clauses.append(" {}({}) AS {}_{}".format(opTransfrom(calculate_op), columnTransfrom(key), calculate_op, key))
      calculate_clauses.append(",".join(calculate_keys_clauses))
    select_clause = ', '.join(calculate_clauses)

    # 生成FROM子句
    from_clause = job['from'].name

    # 生成WHERE子句
    where_clause = generate_where_clause(job['filter'])

    # 构建完整的SQL语句
    sql_query = "SELECT {} FROM {} WHERE {}".format(select_clause, from_clause, where_clause)

    #语句间隔
    sql_query += " "

    # 生成ORDER BY子句
    if 'order_by' in job:
        order_by_clause = generate_order_by_clause(job['order_by'])
        sql_query += "ORDER BY {}".format(order_by_clause)
    
    #语句间隔
    sql_query += " "

    # 生成LIMIT子句
    if 'limit' in job:
        limit_clause = str(job['limit'])
        sql_query += "LIMIT {}".format(limit_clause)

    return sql_query


def generate_where_clause(filter_data):
    operator = filter_data['op']
    filters = filter_data['filters']

    filter_clauses = []
    for filter_item in filters:
        key = filter_item['key']
        value = filter_item['value']
        op = filter_item['op']

        if op == 'GT':
            filter_clause = "{} > {}".format(key, value)
        elif op == 'GE':
            filter_clause = "{} >= {}".format(key, value)
        elif op == 'EQ':
            filter_clause = "{} = {}".format(key, value)
        elif op == 'NE':
            filter_clause = "{} != {}".format(key, value)
        elif op == 'LT':
            filter_clause = "{} < {}".format(key, value)
        elif op == 'LE':
            filter_clause = "{} <= {}".format(key, value)
        elif op == 'IN':
            filter_clause = "{} IN {}".format(key, str(tuple(value)))
        else:
            TypeError("unknown OP:" + op)
        # 添加其他操作符的处理逻辑

        filter_clauses.append(filter_clause)

    where_clause = " {} ".format(operator).join(filter_clauses) 
    return where_clause


def generate_order_by_clause(order_by_data):
    direction = order_by_data['direction']
    keys = order_by_data['keys']

    order_by_clause = ", ".join(keys)
    order_by_clause += " " + direction

    return order_by_clause

def columnTransfrom(columName):
    if columName == "all":
        return "*"
    else:
        return columName

def opTransfrom(op):
    if op == "LIST":
        return ""
    else:
        return op

if __name__ == "__main__":
    def primitive2Value(value):
        return "'{}'".format(value)
    
    same_hour_watch_live_job = {
        'calculates': [
            {'keys': ['c1','c2'], 'op': 'SUM'},
            {'op': 'COUNT'}
        ],
        'filter': {
            'op': 'AND',
            'filters': [
                {'key': 'PAGE_entry_page_source', 'value': primitive2Value("FEATURED_PAGE"), 'op': 'EQ'},
                {'key': 'PAGE_page', 'value': primitive2Value('FEATURED_PAGE'), 'op': 'EQ'},
                {'key': 'PAGE_action', 'value': primitive2Value('LEAVE'), 'op': 'EQ'},
                {'key': 'PAGE_content_type', 'value': primitive2Value('LIVE'), 'op': 'EQ'},
                {'key': 'PAGE_timestamp', 'value': 100, 'op': 'LT'},
                {'key': 'PAGE_timestamp', 'value': 0, 'op': 'GT'}
            ]
        },
        'order_by': {'direction': 'ASC', 'keys': ['APP_last_state_duration']},
        'limit': 100,
        'from': 'EveTable.PAGE'
    }

    print(generate_sql_query(same_hour_watch_live_job))


    foregroundEvents_job = {
        "calculate": {
            "keys": [
                "APP_last_state_duration"
            ],
            "op": "SUM"
        },
        "filter": {
            "filters": [
                {
                    "key": "APP_timestamp",
                    "value": 10,
                    "op": "LE"
                },
                {
                    "key": "APP_timestamp",
                    "value": 0,
                    "op": "GT"
                },
                {
                    "key": "APP_action",
                    "value": "EnterBackground",
                    "op": "EQ"
                }
            ]
        },
        "from": "EveTable.APP"
    }

    print(generate_sql_query(foregroundEvents_job))
