_metaCache = dict()

class MemoryCache(object):
  def __init__(self, bizId: str) -> None:
    self.bizId = bizId
    _metaCache[bizId] = dict() 

  def get(self, key :str, default: object):
    cache = _metaCache[self.bizId]
    return cache.get(key, default)

  def set(self, key :object, value :object) -> dict:
    cache = _metaCache[self.bizId]
    cache.set(key, value)
      