--- @class Number
Function = require 'EveLuaKit.container'

Number = {}

--- 函数把除数和余数运算结果结合起来，分别返回商和余数 (a // b, a % b)
--- 
--- @eve_version 1.0.0
--- @param moduleKey string
--- @return number, number
function Number:divmod(a, b)
    local res = { math.floor(a / b), math.fmod(a, b) }
    return Container:unpack(res)
end

--- 函数用于将给定参数转换为布尔类型，如果没有参数，返回 False
--- 
--- @eve_version 1.0.0
--- @param moduleKey string
--- @return boolean
function Number:bool(x)
    if x == false or x == nil or x == 0 then
        return false
    end

    if type(x) == "table" then
        if x._is_list or x._is_dict then
            return next(x._data) ~= nil
        end
    end

    return true
end 

return Number