--- @class List

List = {}

--- 创建并返回一个新的List数组
--- 
--- @eve_version 1.0.0
--- @param  const_list table
--- @return List
function List:new(const_list)
    local result = {}
    result._data = {}
    result._is_list = true

    if const_list ~= nil then
        for _, v in ipairs(const_list) do
            table.insert(result._data, v)
        end
    end

    local iterator_index = nil
    setmetatable(result, {
        __index = function(self, index)
            if type(index) == "number" then
                if index < 0 then
                    index = #self._data + index
                end
                return rawget(self._data, index + 1)
            end

            return List[index]
        end,
        __newindex = function(self, index, value)
            self._data[index] = value
        end,
        __call = function(self, _, idx)
            if self._data == nil and iterator_index ~= nil then
                iterator_index = nil
            end

            local v = nil
            iterator_index, v = next(self._data, iterator_index)

            return v, iterator_index
        end,
    })
    return result
end

--- 给数组插入一个元素
---
--- @generic T
--- @eve_version 1.0.0
--- @param  item T
--- @return boolean
function List:append(item)
    if item == nil then
        return false
    end
    table.insert(self._data, item)
    return true
end

--- 列表末尾一次性追加另一个序列中的多个值
---
--- @eve_version 1.0.0
--- @param  iterable table
--- @return boolean
function List:extend(iterable)
    if iterable == nil then
        return false
    end
    for value in iterable do
        table.insert(self._data, value)
    end
    return true
end

--- 列表在指定位置插入元素
---
--- @generic T
--- @eve_version 1.0.0
--- @param  index integer
--- @param  value T
--- @return boolean
function List:insert(index, value)
    table.insert(self._data, index, value)
    return true
end

--- 用于移除列表中某个值的第一个匹配项
---
--- @generic T
--- @eve_version 1.0.0
--- @param  value T
--- @return boolean
function List:remove(value)
    for i, v in ipairs(self._data) do
        if value == v then
            table.remove(self._data, i)
            return true
        end
    end
    return false
end

--- 删除列表中指定索引的元素，并返回被删除的元素
---
--- @generic T
--- @eve_version 1.0.0
--- @param  index integer
--- @return T
function List:pop(index)
    index = index or #self._data
    local value = self._data[index]
    table.remove(self._data, index)
    return value
end

--- 清空列表
---
--- @eve_version 1.0.0
--- @return nil
function List:clear()
    self._data = {}
end

--- 拷贝列表
---
--- @eve_version 1.0.0
--- @return List
function List:copy()
    return List:new(self._data)
end

--- 查找一个value在数组中的索引
--- @generic T
--- @eve_version 1.0.0
--- @param  value T
--- @param  start integer
--- @param  end_ integer
--- @return integer
function List:index(value, start, end_)
    start = start or 1
    end_ = end_ or #self._data

    for i = start, end_, 1 do
        if self._data[i] == value then
            return i
        end
    end

    return -1
end

--- 返回数组中某个元素的数量
--- @generic T
--- @eve_version 1.0.0
--- @param  value T
--- @return integer
function List:count(value)
    local cnt = 0
    for _, v in ipairs(self._data) do
        if v == value then
            cnt = cnt + 1
        end
    end

    return cnt
end

--- 数组排序，默认升序
---
--- @eve_version 1.0.0
--- @param  reverse boolean
--- @return nil
function List:sort(reverse)
    reverse = reverse or false

    table.sort(self._data, function(a, b)
        if reverse then
            return a < b
        end

        return a > b
    end)
end

--- 对列表中的元素进行反向排序
---
--- @eve_version 1.0.0
--- @return nil
function List:reverse()
    local new_data = {}
    for i = #self._data, 1, -1 do
        table.insert(new_data, self._data[i])
    end

    self._data = new_data
end

--- 判断数组中是否包含某个元素
---
--- @eve_version 1.0.0
--- @generic T
--- @param item T
--- @return boolean
function List:contains(item)
    for v in self do
        if v == item then
            return true
        end
    end

    return false
end

return List
