KSwitch = {}

INTERFACE_GET_DATA_FROM_DATABRIDGE = "getDataFromBridgeWithScheme"

--- 查询一个String类型的客户端开关
---
--- @eve_version 1.0.0
--- @param key string
--- @param defaultValue string
function KSwitch:getString(key, defaultValue)
    local luaBridageParam = {}
    if (defaultValue == nil) then
        defaultValue = ""
    end
    luaBridageParam["scheme"] = "getKswitchString"
    luaBridageParam["data"] = {key, defaultValue}

    local retTable = eveCommunicate(INTERFACE_GET_DATA_FROM_DATABRIDGE, luaBridageParam)
    if (retTable["code"] ~= 0) then
        return defaultValue
    end
    return retTable["data"]
end

--- 查询一个Long类型的客户端开关
---
--- @eve_version 1.0.0
--- @param key string
--- @param defaultValue long
function KSwitch:getLong(key, defaultValue)
    local luaBridageParam = {}
    if (defaultValue == nil) then
        defaultValue = 0
    end
    luaBridageParam["scheme"] = "getKswitchLong"
    luaBridageParam["data"] = {key, defaultValue}

    local retTable = eveCommunicate(INTERFACE_GET_DATA_FROM_DATABRIDGE, luaBridageParam)
    if (retTable["code"] ~= 0) then
        return defaultValue
    end
    return retTable["data"]
end

--- 查询一个Bool类型的客户端开关
---
--- @eve_version 1.0.0
--- @param key string
--- @param defaultValue bool
function KSwitch:getBool(key, defaultValue)
    local luaBridageParam = {}
    if (defaultValue == nil) then
        defaultValue = false
    end
    luaBridageParam["scheme"] = "getKswitchBool"
    luaBridageParam["data"] = {key, defaultValue}

    local retTable = eveCommunicate(INTERFACE_GET_DATA_FROM_DATABRIDGE, luaBridageParam)
    if (retTable["code"] ~= 0) then
        return defaultValue
    end
    return retTable["data"]
end


--- 查询一个Float类型的客户端开关
---
--- @eve_version 1.0.0
--- @param key string
--- @param defaultValue float
function KSwitch:getFloat(key, defaultValue)
    local luaBridageParam = {}
    if (defaultValue == nil) then
        defaultValue = 0.0
    end
    luaBridageParam["scheme"] = "getKswitchFloat"
    luaBridageParam["data"] = {key, defaultValue}

    local retTable = eveCommunicate(INTERFACE_GET_DATA_FROM_DATABRIDGE, luaBridageParam)
    if (retTable["code"] ~= 0) then
        return defaultValue
    end
    return retTable["data"]
end

return KSwitch