--- @class DateTime
---

DateTime = {}

--- 获取当前时刻的毫秒时间戳
--- 
--- @eve_version 1.0
--- @return number
function DateTime:getMsTime()
    return getMsTime()
end

--- 获取当前时刻的格式化日期字符串
--- 
--- @eve_version 1.0
--- @param formatePlaceholder 用来标识日期格式的占位符，如```"%Y-%m-%d %H:%M:%S"```
--- @return table
function DateTime:getFormattedDate(formatePlaceholder)
    return os.date(formatePlaceholder, os.time())
end

--- 获取今天是周几, 周一返回数字"1", 以此类推, 周日返回"7"
--- 
--- @eve_version 1.0
--- @return number
function DateTime:getWeekDay()
    local date = os.date("*t", os.time());
    -- lua原生的接口，周日返回1，所以这里做一次转换
    local wday = (date.wday + 6) % 8
    return wday 
end

return DateTime