--- @class Container

require 'EveLuaKit.function'

Container = {}

function Container:all(iterable)
    for element in iterable do
        if not element then
            return false
        end
    end
    return true
end

function Container:any(iterable)
    for element in iterable do
        if element then
            return true
        end
    end
    return false
end

function Container:len(t)
    if t == nil then
        return 0
    end

    if type(t._data) == "table" then
        return #t._data
    end

    return #t
end

function Container:range(from, to, step)
    assert(from ~= nil)
    
    if to == nil then
        to = from
        from = 1        
    end

    step = step or 1

    local i = from
    
    return function()
        ret = i
        if (step > 0 and i > to) or (step < 0 and i < to) then
            return nil
        end
        
        i = i + step
        return ret
    end
end

function Container:enumerate(t, start)
    start = start or 0

    local data = t
    if t._is_list then
        data = t._data
    end

    local i, v = next(data, nil)
    return function()
        local index, value = i, v
        i, v = next(data, i)

        if index == nil then
            return nil
        end

        return index + start - 1, value
    end
end

function Container:operator_in(item, items)
    if type(items) == "table" then
        for v in items do
            if v == item then
                return true
            end
        end
    elseif type(items) == "string" and type(item) == "string" then
        return string.find(items, item, 1, true) ~= nil
    end

    return false
end

function Container:map(func, items)
    if Function:callable(func) == false then
        return
    end

    if type(items._data) == "table" then
        for item in items do
            func(item)
        end
        return
    end

    if type(items) == "table" then
        for index, v in pairs(items) do
            func(v)
        end
        return
    end
end

function Container:apply(func, items)
    local retList = List:new({})
    if Function:callable(func) == false then
        return
    end

    if type(items._data) == "table" then
        for item in items do
            retList:append(func(item))
        end
        return retList
    end

    if type(items) == "table" then
        for index, v in pairs(items) do
            retList:append(func(v))
        end
        return retList
    end
end

function Container:slice(tbl, start, length)
    length = length or 1
    start = start or 1
    local endd = start + length
    local sliced = {}
    local remainder = {}
    for item, index in tbl do
       if index < start or index >= endd then
          table.insert(remainder, item)
       else
          table.insert(sliced, item)
       end
    end
    return sliced, remainder
end
 
---如果数组每个元素都是true则返回true,反之返回false
--- 
---@eve_version 1.0.0
---@param iterable any
---@return boolean
function all(iterable)
    return Container:all(iterable)
end

---如果数组每个元素都是false则返回false,反之返回true
---
---@eve_version 1.0.0
---@param iterable any
---@return boolean
function any(iterable)
    return Container:any(iterable)
end

---返回数组或集合的长度
---
---@eve_version 1.0.0
---@param table table
---@return integer
function len(table)
    return Container:len(table)
end

---返回一个指定步长和起止点的迭代器, 默认从1开始,步长为1
---
---@eve_version 1.0.0
---@param from integer
---@param to? integer
---@param step? integer
---@return function
function range(from, to, step)
    return Container:range(from, to, step)
end

function enumerate(t, start)
    return Container:enumerate(t, start)
end

---对数组的进行切片,分别返回[start, start + length]区间的部分和[start + length, end]区间的部分
---
---@eve_version 1.0.0
---@param tbl List
---@param start integer
---@param length integer
---@return List, List
function slice(tbl, start, length)
    return Container:slice(tbl, start, length)
end

---对数组的每一个元素执行函数func
---
---@eve_version 1.0.0
---@param func function
---@param items List|table
---@return nil
function map(func, items)
    return Container:map(func, items)
end

---对数组的每一个元素执行函数func, 并返回每个func返回值组成的List
---
---@eve_version 1.0.0
---@param func function
---@param items List|table
---@return List
function apply(func, items)
    return Container:apply(func, items)
end

---拆分并返回给定 `list` 中的所有元素。 i代表拆分起始位置,默认值为1, j代表拆分结束位置,默认值为数组长度
---```lua
---return list[i], list[i+1], ···, list[j]
---```
---
---@eve_version 1.0.0
---@generic T
---@param list T[]
---@param i?   integer
---@param j?   integer
---@return T   ...
---@nodiscard
function Container:unpack(list, i, j)
    local unpack = unpack or table.unpack
    return unpack(list, i, j)
end

return Container