<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" version="1.0" xmlns:mssqlcrt="urn:sql-microsoft-com:sqlcrt" xmlns:mssqldbg="urn:sql-microsoft-com:sqldbg">
<xsl:output method="xml" indent="yes"/>

<!-- This ALWAYS GENERATED file contains the definitions for the cartridges
Microsoft Cartridge Interfaces (Analysis Services 2005)
(C) Copyright 1988 - 2003 By Microsoft Corporation.      -->


<!-- Area of Custom parametrizations: these may be modified by customers for specific query customizations  -->
<!-- post-select-query-hint will append the customer-defined string at the end of the generated SELECT statement - e.g. WITH UR -->
<xsl:param name="post-select-query-hint"></xsl:param>

<!-- ODBC pluggable cartridge                              -->

<!-- Area of STANDARD parametrizations: these are externally passed   -->
<xsl:param name="in_CanUseParams">no</xsl:param>
<xsl:param name="in_IdentStartQuotingCharacter">"</xsl:param>
<xsl:param name="in_IdentEndQuotingCharacter">"</xsl:param>
<xsl:param name="in_UnicodeStringPrefix">N</xsl:param>
<xsl:param name="in_StringQuotingCharacter">'</xsl:param>

<!-- Area of CORE parametrizations: These are externally checked      -->
<mssqlcrt:provider type="prefix" managed="yes" native="yes">GENERICODBC</mssqlcrt:provider>
<mssqlcrt:parameter-style native="unnamed" managed="named"/>
<mssqlcrt:dq-datetime-format>YYYY-MM-DD HH:MM:SS</mssqlcrt:dq-datetime-format>
<mssqlcrt:supports-datetime-format>YYYY-MM-DD HH:MM:SS</mssqlcrt:supports-datetime-format>

<mssqlcrt:capabilities>
<mssqlcrt:supports-multiple-distinct-count/>
<mssqlcrt:supports-subselect/>
<mssqlcrt:supports-table-alias/>
<mssqlcrt:supports-column-alias/>
<mssqlcrt:supports-cast/>
<mssqlcrt:supports-union/>
<mssqlcrt:supports-union-all/>
<mssqlcrt:supports-joins/>
<mssqlcrt:supports-distinct-count/>
<mssqlcrt:supports-top-skip/>
<mssqlcrt:requires-orderby-for-skip/>
<mssqlcrt:supports-real-time/>
<mssqlcrt:supports-top/>

<mssqlcrt:pattern-search-expression-type>SQLLIKE</mssqlcrt:pattern-search-expression-type>
<!--
This cartridge is used as the default cartridge for unknown providers
So even though SQL supports larger aliases (at least 128), we'll use a smaller
alias for the other providers. Keeping this conservative. But needs to be populated through dynamic discovery.
-->
<mssqlcrt:limit-table-identifier-length>64</mssqlcrt:limit-table-identifier-length>
<mssqlcrt:limit-column-identifier-length>64</mssqlcrt:limit-column-identifier-length>

<mssqlcrt:limit-parameter-count>2100</mssqlcrt:limit-parameter-count>
<mssqlcrt:limit-in-operator-list-size>2100</mssqlcrt:limit-in-operator-list-size>
<mssqlcrt:limit-temptable-row-count>0</mssqlcrt:limit-temptable-row-count>
<mssqlcrt:limit-batch-insert-count>1000</mssqlcrt:limit-batch-insert-count>

<!-- Map from MSDAInitialize connection string to SQLOLEDB connection string -->
<mssqlcrt:remote-connection-string-mappings>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Provider</mssqlcrt:datasource-property>
<mssqlcrt:remote-property></mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Data Source</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>Server</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Initial Catalog</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>Database</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>User ID</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>UID</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Password</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>PWD</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Integrated Security=SSPI</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>Trusted_Connection=yes</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
</mssqlcrt:remote-connection-string-mappings>

<!-- MATH/TRIG Functions
<mssqlcrt:supports-func>ABS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ACOS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ASIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ATAN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ACOT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>CEILING</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>CURRENCY</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DEGREES</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DIVIDE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EXP</mssqlcrt:supports-func>
<mssqlcrt:supports-func>INT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ISO.CEILING</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LOG</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LOG10</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MAX</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MOD</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MROUND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>POWER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>QUOTIENT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>RADIANS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ROUND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ROUNDDOWN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ROUNDUP</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SIGN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SQRT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SQRTPI</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TAN</mssqlcrt:supports-func>-->

<!-- INFO Functions -->
<mssqlcrt:supports-func>CONTAINSROW</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ISBLANK</mssqlcrt:supports-func>

<!-- LOGICAL Functions -->
<mssqlcrt:supports-func>AND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>IF</mssqlcrt:supports-func>
<mssqlcrt:supports-func>NOT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>OR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SWITCH</mssqlcrt:supports-func>

<!-- DATETIME Functions
<mssqlcrt:supports-func>DATE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DATEDIFF</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DAY</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EDATE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EOMONTH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>HOUR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MINUTE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MONTH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SECOND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TIME</mssqlcrt:supports-func>
<mssqlcrt:supports-func>WEEKDAY</mssqlcrt:supports-func>
<mssqlcrt:supports-func>WEEKNUM</mssqlcrt:supports-func>
<mssqlcrt:supports-func>YEAR</mssqlcrt:supports-func>-->

<!-- String Functions
<mssqlcrt:supports-func>COMBINEVALUES</mssqlcrt:supports-func>
<mssqlcrt:supports-func>CONCATENATE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DATEVALUE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EXACT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>FIND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LEFT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LEN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LOWER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MID</mssqlcrt:supports-func>
<mssqlcrt:supports-func>REPT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>RIGHT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SEARCH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SUBSTITUTE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TIMEVALUE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TRIM</mssqlcrt:supports-func>
<mssqlcrt:supports-func>UPPER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>VALUE</mssqlcrt:supports-func>-->

<!-- Filter Functions
<mssqlcrt:supports-func>KEEPFILTERS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>RELATED</mssqlcrt:supports-func>
<mssqlcrt:supports-func>USERELATIONSHIP</mssqlcrt:supports-func>-->

<!-- Aggregate Functions -->
<mssqlcrt:supports-func>SUM</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MINA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MAX</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MAXA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>AVERAGE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>AVERAGEA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>STDEV.S</mssqlcrt:supports-func>
<mssqlcrt:supports-func>STDEV.P</mssqlcrt:supports-func>
<mssqlcrt:supports-func>VAR.S</mssqlcrt:supports-func>
<mssqlcrt:supports-func>VAR.P</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COUNT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COUNTA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COUNTROWS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DISTINCTCOUNT</mssqlcrt:supports-func>

</mssqlcrt:capabilities>

<mssqlcrt:schema-classes>
<mssqlcrt:schema-class>
<mssqlcrt:managed-provider>System.Data.SqlClient</mssqlcrt:managed-provider>
<mssqlcrt:type>Microsoft.DataWarehouse.Design.SqlSchema, Microsoft.DataWarehouse.AS</mssqlcrt:type>
<mssqlcrt:query-designer>
<mssqlcrt:type>Microsoft.DataWarehouse.Controls.SqlClientQueryDesigner, Microsoft.DataWarehouse.AS</mssqlcrt:type>
</mssqlcrt:query-designer>
</mssqlcrt:schema-class>
<mssqlcrt:schema-class>
<mssqlcrt:managed-provider>System.Data.OleDb</mssqlcrt:managed-provider>
<mssqlcrt:type>Microsoft.DataWarehouse.Design.OleDbSchema, Microsoft.DataWarehouse.AS</mssqlcrt:type>
<mssqlcrt:query-designer>
<mssqlcrt:type>Microsoft.DataWarehouse.Controls.OleDbQueryDesigner, Microsoft.DataWarehouse.AS</mssqlcrt:type>
</mssqlcrt:query-designer>
</mssqlcrt:schema-class>
<mssqlcrt:schema-class>
<mssqlcrt:managed-provider>System.Data.Odbc</mssqlcrt:managed-provider>
<mssqlcrt:type>Microsoft.DataWarehouse.Design.OdbcSchema, Microsoft.DataWarehouse.AS</mssqlcrt:type>
</mssqlcrt:schema-class>
</mssqlcrt:schema-classes>

<!-- Area of internal parametrizations -->
<!-- overrideOfUseParams:
yes      = use always parametric queries
no       = never use parametric queries
nosubsel = use as yes, but not on subselects
auto     = use the value of in_CanUseParams to determine -->
<xsl:variable name="overrideOfUseParams">auto</xsl:variable>
<!-- shouldProduceDebug:
yes      = produce debug information
no       = do not produce debug information -->
<xsl:variable name="shouldProduceDebug">yes</xsl:variable>


<!-- Area of global variables initializations -->
<xsl:variable name="UseParams">
<xsl:choose>
<xsl:when test="normalize-space($overrideOfUseParams) = 'yes' or (normalize-space($overrideOfUseParams) = 'auto' and normalize-space($in_CanUseParams)='yes')">yes</xsl:when>
<xsl:when test="normalize-space($overrideOfUseParams) = 'nosubsel'">nosubsel</xsl:when>
<xsl:otherwise>no</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="ProduceDebug" select="$shouldProduceDebug"/>
<xsl:variable name="IdentifierStartQuotingCharacter" select="normalize-space($in_IdentStartQuotingCharacter)"/>
<xsl:variable name="IdentifierEndQuotingCharacter" select="normalize-space($in_IdentEndQuotingCharacter)"/>
<xsl:variable name="UnicodeStringPrefix" select="normalize-space($in_UnicodeStringPrefix)"/>
<xsl:variable name="StringQuotingCharacter" select="normalize-space($in_StringQuotingCharacter)"/>

<mssqlcrt:sourceprovidertypename>
<supportedtypes>
<bigint>I8</bigint>
<int>I8</int>
<integer>I8</integer>
<smallint>I8</smallint>
<tinyint>I8</tinyint>
<decimal>CY</decimal>
<numeric>R8</numeric>
<float>R8</float>
<real>R8</real>
<double_precision>R8</double_precision>
<double>R8</double>
<date>DATE</date>
<time>DATE</time>
<timestamp>DATE</timestamp>
<datetime>DATE</datetime>
<bit>BOOL</bit>
<binary>STR</binary>
<varbinary>STR</varbinary>
<char>STR</char>
<varchar>STR</varchar>
<character>STR</character>
<nchar>STR</nchar>
<nvarchar>STR</nvarchar>
</supportedtypes>
<unicode>
<nchar/>
<nvarchar/>
</unicode>
<date format="YYYY-MM-DD">
<date/>
</date>
<time format="HH:MM:SS">
<time/>
</time>
<agg_upcast>
<int/>
<integer/>
<tinyint/>
<smallint/>
</agg_upcast>
<fixed_length_string_types>
<char/>
<character/>
<nchar/>
</fixed_length_string_types>
</mssqlcrt:sourceprovidertypename>
<!-- Generated statement packaging -->
<xsl:template match="/">
<xsl:element name="Statement">

<!-- Generate query -->
<xsl:element name="Text">
<xsl:apply-templates select="./Statement/*[1]"/>
</xsl:element>

<!-- Generate parameters -->
<xsl:if test="(/Statement[not(@DQInlineParams)]) and count(./Statement/Parameters/Parameter)!=0 and ((normalize-space($UseParams)='yes') or (normalize-space($UseParams)='nosubsel'))">
<xsl:element name="Parameters">
<xsl:choose>
<xsl:when test="/Statement/*[1]//Parameter/@ParamName">
<xsl:for-each select="./Statement/Parameters/Parameter">
<xsl:element name="Parameter">
<xsl:attribute name="ref">
<xsl:value-of select="./@id"/>
</xsl:attribute>
</xsl:element>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<xsl:for-each select="./Statement/*[1]//Parameter">
<xsl:element name="Parameter">
<xsl:attribute name="ref">
<xsl:value-of select="./@ref"/>
</xsl:attribute>
</xsl:element>
</xsl:for-each>
</xsl:otherwise>
</xsl:choose>
</xsl:element>
</xsl:if>

<!-- Generate debug info -->
<xsl:if test="$ProduceDebug='yes'">
<xsl:element name="mssqldbg:DebugInfo">
<xsl:element name="mssqldbg:GenerateParametricInfo">
<xsl:attribute name="mssqldbg:Value">
<xsl:value-of select="$UseParams"/>
</xsl:attribute>
<xsl:element name="mssqldbg:External">
<xsl:value-of select="$in_CanUseParams"/>
</xsl:element>
<xsl:element name="mssqldbg:Internal">
<xsl:value-of select="$overrideOfUseParams"/>
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:if>

</xsl:element>
</xsl:template>

<!-- Print values: ? for parametric queries and convert expressions
for non-parametric queries -->
<xsl:template match="Parameter">
<xsl:choose>
<xsl:when test="(/Statement[not(@DQInlineParams)]) and ($UseParams = 'yes' or $UseParams = 'nosubsel')">
<xsl:choose>
<xsl:when test="./@ParamName">
@<xsl:value-of select="./@ParamName"/>
</xsl:when>
<xsl:otherwise>
?
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="print-non-parametric-parameter-ref">
<xsl:with-param name="parameter-reference" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="InlineParameter">
<xsl:call-template name="print-non-parametric-parameter">
<xsl:with-param name="parameter" select="./Parameter"/>
</xsl:call-template>
</xsl:template>

<!-- ROW_NUMBER() are 1 based. -->
<!-- Top clause -->
<xsl:template name="TopFilter">
<xsl:param name="SelectExpr"/>
<xsl:param name="TopExpr"/>
SELECT * FROM (<xsl:value-of select="$SelectExpr" />) AS t WHERE <xsl:call-template name="quote-identifier"><xsl:with-param name="identifier">__row_no_75f9d9c9-6da4-4023-a313-f7052e71ae09</xsl:with-param></xsl:call-template> &lt;= <xsl:value-of select="$TopExpr"/>
</xsl:template>

<!-- Assumes that the select column expressions list is not empty -->
<xsl:template name="RowNumberExpression">
<xsl:param name="OrderByExpr"/>
, ROW_NUMBER() OVER (<xsl:value-of select="$OrderByExpr"/>) AS <xsl:call-template name="quote-identifier"><xsl:with-param name="identifier">__row_no_75f9d9c9-6da4-4023-a313-f7052e71ae09</xsl:with-param></xsl:call-template>
</xsl:template>

<!-- Select statement -->
<xsl:template match="Select">
<xsl:variable name="SelectStmt">
SELECT
<xsl:apply-templates select="./Distinct"/>
<xsl:apply-templates select="./ColumnExpressions"/>
<xsl:if test="count(child::Top) != 0 and count(child::OrderBy) != 0">
<xsl:call-template name="RowNumberExpression">
<xsl:with-param name="OrderByExpr"><xsl:apply-templates select="./OrderBy"/></xsl:with-param>
</xsl:call-template>
</xsl:if>
<xsl:apply-templates select="./Sources"/>
<xsl:apply-templates select="./Where"/>
<xsl:apply-templates select="./GroupBy"/>
<xsl:if test="count(child::Top) = 0 or count(child::OrderBy) = 0">
<xsl:apply-templates select="./OrderBy"/>
</xsl:if>
<xsl:if test="name(..) = 'Statement'">
<xsl:text> </xsl:text><xsl:value-of select="$post-select-query-hint"/>
</xsl:if>
</xsl:variable>

<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert' and name(..) != 'Union' and name(..) != 'UnionAll'">
(
</xsl:if>

<xsl:choose>
<xsl:when test="count(child::Top) != 0 and count(child::OrderBy) != 0">
<xsl:call-template name="TopFilter">
<xsl:with-param name="SelectExpr" select="$SelectStmt"/>
<xsl:with-param name="TopExpr" select="./Top/*[1]"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$SelectStmt"/>
</xsl:otherwise>
</xsl:choose>

<!--<xsl:apply-templates select="./Top"/>-->
<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert' and name(..) != 'Union' and name(..) != 'UnionAll'">
)
</xsl:if>
</xsl:template>

<xsl:template match="Distinct">
DISTINCT
</xsl:template>

<xsl:template match="As">
<xsl:apply-templates select="./*[1]"/> AS <xsl:apply-templates select="./*[2]"/>
</xsl:template>

<xsl:template match="Sources">
FROM <xsl:choose>
<xsl:when test="count(./Join) != 0 or count(./CrossJoin)!= 0">
<xsl:apply-templates select="./Join"/>
<xsl:apply-templates select="./CrossJoin"/>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="print-children-list"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Join">
(<xsl:apply-templates select="./*[2]"/><xsl:call-template name="JoinType"/> <xsl:apply-templates select="./*[3]"/> on <xsl:apply-templates select="./On/*"/>)
</xsl:template>

<xsl:template name="JoinType">
<xsl:text>&#10;&#13;</xsl:text>
<xsl:variable name="value-node">
<xsl:value-of select="normalize-space(./JoinType/text())"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$value-node = 'LeftOuterJoin'" > LEFT OUTER JOIN </xsl:when>
<xsl:when test="$value-node = 'RightOuterJoin'"> RIGHT OUTER JOIN </xsl:when>
<xsl:when test="$value-node = 'FullOuterJoin'" > FULL OUTER JOIN </xsl:when>
<xsl:when test="$value-node = 'InnerJoin'"     > INNER JOIN </xsl:when>
</xsl:choose>
<xsl:text>&#10;&#13;</xsl:text>
</xsl:template>

<xsl:template match="CrossJoin">
<xsl:text>&#10;&#13;</xsl:text>
<xsl:apply-templates select="./*[1]"/> cross join <xsl:apply-templates select="./*[2]"/>
<xsl:text>&#10;&#13;</xsl:text>
</xsl:template>

<xsl:template match="GroupBy">
GROUP BY <xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="OrderBy">
ORDER BY <xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="Where">
WHERE <xsl:apply-templates select="./*"/>
</xsl:template>

<xsl:template match="Column">
<xsl:apply-templates select="./Asterisk"/>
<xsl:apply-templates select="./Name"/>
<xsl:apply-templates select="./Null"/>
</xsl:template>

<xsl:template match="ColumnExpressions">
<xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="Table">
<xsl:call-template name="build-quoted-schema-object"/>
</xsl:template>

<xsl:template match="SQLColumn">
<xsl:variable name="table">
<xsl:if test="name(../../..) != 'Recursion' and (name(..)!='Count' or name(./Column/*[1]) != 'Asterisk')"><xsl:apply-templates select="./Table"/></xsl:if>
</xsl:variable>
<xsl:variable name="column">
<xsl:apply-templates select="./Column"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$table = ''">
<xsl:value-of select="$column"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat($table,'.', $column)"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- Null -->
<xsl:template match="Null">null</xsl:template>

<xsl:template match="Table/Name|View/Name|Index/Name|Column/Name|Database/Name|Schema">
<xsl:call-template name="quote-identifier"/>
</xsl:template>

<xsl:template match="OpaqueExpression">
<xsl:if test="name(..) = 'As' and name(../..) = 'Sources'">
(
</xsl:if>
<xsl:value-of select="."/>
<xsl:if test="name(..) = 'As' and name(../..) = 'Sources'">
)
</xsl:if>
</xsl:template>

<!--OpOrderExpression-->
<!--Child nodes here should never contain parameter passed into query, except the case when Op1Type = 'SqlBool'.-->
<xsl:template match="OpOrderExpression">
<xsl:choose>
<xsl:when test="@Op1Type = 'SqlBool'">
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="'SqlBool'"/>
<xsl:with-param name="target-type" select="'SqlBit'"/>
<xsl:with-param name="value-node" select="./*[1]"/>
</xsl:call-template>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:when>
<xsl:when test="@Op1Nullable = 'false' or @Op1Type = 'String'">
<xsl:apply-templates select="./*[1]"/>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime'">
COALESCE(<xsl:apply-templates select="./*[1]"/>, <xsl:call-template name="print-datetime-origin-value"><xsl:with-param name="db-type" select="@Op1SourceType"/></xsl:call-template>)
</xsl:when>
<xsl:otherwise>
COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
, (CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN 0 ELSE 1 END)
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Asc">
ASC
</xsl:template>

<xsl:template match="Desc">
DESC
</xsl:template>
<!-- Asterisk -->
<xsl:template match="Asterisk">*</xsl:template>
<!-- Count/Min/Max/Sum                                                -->
<xsl:template match="Min|Max|Sum">
<xsl:variable name="function">
<xsl:choose>
<xsl:when test="name()='Min'"> MIN</xsl:when>
<xsl:when test="name()='Max'"> MAX</xsl:when>
<xsl:when test="name()='Sum'"> SUM</xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="$function"/>( <xsl:apply-templates select="./*[1]"/> )
</xsl:template>

<xsl:template match="Count">
COUNT( <xsl:apply-templates select="./*[1]"/> <xsl:apply-templates select="./*[2]"/> )
</xsl:template>

<xsl:template match="OpSqr">
<xsl:variable name="value"><xsl:apply-templates select="./*[1]"/></xsl:variable>
(<xsl:value-of select="$value"/> * <xsl:value-of select="$value"/>)
</xsl:template>

<!-- Binary expressions -->
<!-- Equal/NotEqual/Greater/GreaterOrEqual/Less/LessOrEqual/In/And/Or/Plus/Minus/Divide/Multiply Expressions -->
<xsl:template match="Equal|NotEqual|Greater|GreaterOrEqual|Less|LessOrEqual|In|And|Or|Plus|Minus|Divide|Multiply">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='Equal'"         > = </xsl:when>
<xsl:when test="name()='NotEqual'"      > &lt;&gt; </xsl:when>
<xsl:when test="name()='Greater'"       > &gt; </xsl:when>
<xsl:when test="name()='GreaterOrEqual'"> &gt;= </xsl:when>
<xsl:when test="name()='Less'"          > &lt; </xsl:when>
<xsl:when test="name()='LessOrEqual'"   > &lt;= </xsl:when>
<xsl:when test="name()='In'"            > IN </xsl:when>
<xsl:when test="name()='And'"           > AND </xsl:when>
<xsl:when test="name()='Or'"            > OR </xsl:when>
<xsl:when test="name()='Plus'"          > + </xsl:when>
<xsl:when test="name()='Minus'"         > - </xsl:when>
<xsl:when test="name()='Divide'"        > / </xsl:when>
<xsl:when test="name()='Multiply'"      > * </xsl:when>
</xsl:choose>
</xsl:variable>
(
<xsl:call-template name="print-children-list">
<xsl:with-param name="operator" select="$operator"/>
</xsl:call-template>
)
</xsl:template>

<xsl:template match="OpInList">(<xsl:call-template name="print-children-list"/>)</xsl:template>

<xsl:template match="OpIn|OpNaryOr">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='OpIn'"> IN </xsl:when>
<xsl:when test="name()='OpNaryOr'"> OR </xsl:when>
</xsl:choose>
</xsl:variable>
(<xsl:call-template name="print-children-list"> <xsl:with-param name="operator" select="$operator"/> </xsl:call-template>)
</xsl:template>
<!-- Postfix unary expressions -->
<!-- IsNull
expressions -->
<xsl:template match="IsNull">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='IsNull'"> IS NULL </xsl:when>
</xsl:choose>
</xsl:variable>
(
<xsl:apply-templates select="./*[1]"/>
<xsl:value-of select="$operator"/>
)
</xsl:template>
<!-- True and False -->
<xsl:template match="True">
<xsl:choose>
<xsl:when test="@SqlBool = 'true'">1=1</xsl:when>
<xsl:otherwise>1</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="False">
<xsl:choose>
<xsl:when test="@SqlBool = 'true'">1=0</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- Size (optional) -->
<xsl:template match="Size">
( <xsl:value-of select="./text()"/> )
</xsl:template>
<!-- Precision (optional) -->
<xsl:template match="Precision">
( <xsl:value-of select="./text()"/>
</xsl:template>
<!-- Scale (optional) -->
<xsl:template match="Scale">
, <xsl:value-of select="./text()"/> )
</xsl:template>
<!-- Cast -->
<xsl:template match="Cast">
CAST(<xsl:apply-templates select="./*[1]"/> AS <xsl:apply-templates select="./*[2]"/>)
</xsl:template>

<xsl:template name="print-datetime-origin-value">
<xsl:param name="db-type"/>
<xsl:choose>
<xsl:when test="$db-type = 'DBTYPE_DBTIME'">CAST(<xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string">00:00:00</xsl:with-param></xsl:call-template> AS TIME)</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBDATE'">CAST(<xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string">1899-12-30</xsl:with-param></xsl:call-template> AS DATE)</xsl:when>
<!--Here we are relying on implicit casting from string to DateTime or TimeStamp on the data-source because for SQL ODBC provider there is a bug in the CAST('literal' AS TIMESTAMP) where it uses non-ANSI Datatype mapping.-->
<xsl:otherwise><xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string">1899-12-30 00:00:00</xsl:with-param></xsl:call-template></xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="OpAddDays">
<xsl:param name="days-value"/>
<xsl:param name="date-value"/>
(CASE WHEN <xsl:value-of select="$days-value"/> IS NULL THEN <xsl:value-of select="$date-value"/>
ELSE
{fn TIMESTAMPADD(SQL_TSI_SECOND, CAST((<xsl:value-of select="$days-value"/> - CAST(<xsl:value-of select="$days-value"/> AS INTEGER)) AS FLOAT(53)) * 86400, {fn TIMESTAMPADD(SQL_TSI_DAY, CAST(<xsl:value-of select="$days-value"/> AS INTEGER), {fn CONVERT(<xsl:value-of select="$date-value"/>, SQL_TIMESTAMP)})})}
END)
</xsl:template>

<xsl:template name="OpDaysDiff">
<xsl:param name="date-value1"/>
<xsl:param name="date-value2"/>
CAST(CAST({fn TIMESTAMPDIFF(SQL_TSI_DAY, <xsl:value-of select="$date-value1"/>, <xsl:value-of select="$date-value2"/>)} AS DECIMAL(19,0)) * 86400 + {fn TIMESTAMPDIFF(SQL_TSI_SECOND, {fn TIMESTAMPADD(SQL_TSI_DAY, {fn TIMESTAMPDIFF(SQL_TSI_DAY, <xsl:value-of select="$date-value1"/>, <xsl:value-of select="$date-value2"/>)}, <xsl:value-of select="$date-value1"/>)}, <xsl:value-of select="$date-value2"/>)} AS FLOAT(53)) / 86400
</xsl:template>

<xsl:template name="OpFloatToDateTime">
<xsl:param name="value-node"/>
(CASE
WHEN <xsl:value-of select="$value-node"/> IS NULL THEN NULL ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="days-value"><xsl:value-of select="$value-node"/></xsl:with-param>
<xsl:with-param name="date-value"><xsl:call-template name="print-datetime-origin-value"/></xsl:with-param>
</xsl:call-template>
END)
</xsl:template>

<xsl:template name="OpDateTimeToFloat">
<xsl:param name="value-node"/>
(CASE
WHEN <xsl:value-of select="$value-node"/> IS NULL THEN NULL ELSE
<xsl:call-template name="OpDaysDiff">
<xsl:with-param name="date-value1"><xsl:call-template name="print-datetime-origin-value"/></xsl:with-param>
<xsl:with-param name="date-value2"><xsl:value-of select="$value-node"/></xsl:with-param>
</xsl:call-template>
END)
</xsl:template>
<!-- OpCast                                                             -->
<!-- Known types:                                                       -->
<!--     Double                                                         -->
<!--     Integer                                                        -->
<!--     Currency                                                       -->
<!--     SqlBool                                                        -->
<!--     SqlBit                                                         -->
<!--     Datetime                                                       -->
<!--     String                                                         -->
<xsl:template name="OpCast" match="OpCast">
<xsl:param name="param-type" select="@Op1Type"/>
<xsl:param name="target-type" select="@ResultType"/>
<xsl:param name="unicode" select="@Unicode"/>
<xsl:param name="source-target-type" select="@SourceTargetType"/>
<xsl:param name="value-node" select="./*[1]"/>
<xsl:choose>
<xsl:when test="$target-type = 'Double'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
CAST(<xsl:call-template name="OpDateTimeToFloat"><xsl:with-param name="value-node"><xsl:apply-templates select="$value-node"/></xsl:with-param></xsl:call-template> AS FLOAT(53))
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
CAST(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END AS FLOAT(53))
</xsl:when>
<xsl:otherwise>
CAST(<xsl:apply-templates select="$value-node"/> AS FLOAT(53))
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'Integer'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
CAST(
<xsl:call-template name="OpDateTimeToFloat"><xsl:with-param name="value-node"><xsl:apply-templates select="$value-node"/></xsl:with-param></xsl:call-template> +
CASE WHEN <xsl:call-template name="OpDateTimeToFloat"><xsl:with-param name="value-node"><xsl:apply-templates select="$value-node"/></xsl:with-param></xsl:call-template> &lt; 0
THEN -0.5 ELSE 0.5 END AS DECIMAL(19,0)
)
</xsl:when>
<xsl:when test="$param-type = 'Double' or $param-type = 'Currency'">
CAST(<xsl:apply-templates select="$value-node"/> + CASE WHEN <xsl:apply-templates select="$value-node"/> &lt; 0 THEN -0.5 ELSE 0.5 END AS DECIMAL(19,0))
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
CAST(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END AS DECIMAL(19,0))
</xsl:when>
<xsl:otherwise>
CAST(<xsl:apply-templates select="$value-node"/> AS DECIMAL(19,0))
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'Currency'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
CAST(<xsl:call-template name="OpDateTimeToFloat"><xsl:with-param name="value-node"><xsl:apply-templates select="$value-node"/></xsl:with-param></xsl:call-template> AS DECIMAL(19,4))
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
CAST(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END AS DECIMAL(19,4))
</xsl:when>
<xsl:otherwise>
CAST(<xsl:apply-templates select="$value-node"/> AS DECIMAL(19,4))
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'SqlBool'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
<xsl:apply-templates select="$value-node"/> &lt;&gt; <xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
<xsl:apply-templates select="$value-node"/>
</xsl:when>
<xsl:when test="$param-type = 'String'">
(CAST(<xsl:apply-templates select="$value-node"/> AS BIT) = 1)
</xsl:when>
<xsl:otherwise>
(<xsl:apply-templates select="$value-node"/> &lt;&gt; 0)
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'SqlBit'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
CASE WHEN <xsl:apply-templates select="$value-node"/> &lt;&gt; <xsl:call-template name="print-datetime-origin-value"/> THEN 1 ELSE 0 END
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
CAST(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END AS BIT)
</xsl:when>
<xsl:otherwise>
CAST(<xsl:apply-templates select="$value-node"/> AS BIT)
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'Datetime'">
<xsl:choose>
<xsl:when test="$param-type = 'SqlBool'">
<xsl:call-template name="OpFloatToDateTime"><xsl:with-param name="value-node">CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END</xsl:with-param></xsl:call-template>
</xsl:when>
<xsl:when test="$param-type = 'Double'
or $param-type = 'Integer'
or $param-type = 'Currency'
or $param-type = 'SqlBit'">
<xsl:call-template name="OpFloatToDateTime"><xsl:with-param name="value-node"><xsl:apply-templates select="$value-node"/></xsl:with-param></xsl:call-template>
</xsl:when>
<xsl:otherwise>
{fn CONVERT(<xsl:apply-templates select="$value-node"/>, SQL_TIMESTAMP)}
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'String'">
<xsl:choose>
<xsl:when test="$param-type = 'SqlBit'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> = 1 THEN 'TRUE' ELSE 'FALSE' END)
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 'TRUE' ELSE 'FALSE' END)
</xsl:when>
<xsl:when test="$unicode = 'true'">
CAST(<xsl:apply-templates select="$value-node"/> AS NCHAR VARYING(4000))
</xsl:when>
<xsl:otherwise>
CAST(<xsl:apply-templates select="$value-node"/> AS VARCHAR(4000))
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$source-target-type != ''">
CAST(<xsl:apply-templates select="$value-node"/> AS <xsl:apply-templates select="$source-target-type"/>)
</xsl:when>

<xsl:otherwise>
<xsl:message terminate="yes">ODBC cartridge error: OpCast: ResultType is not specified</xsl:message>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpCase -->
<xsl:template match="OpCase">
(
CASE
<xsl:for-each select="IfClause">
WHEN <xsl:apply-templates select="./Condition/*[1]"/>
THEN <xsl:apply-templates select="./Then/*[1]"/>
</xsl:for-each>
ELSE <xsl:apply-templates select="./Else/*[1]"/>
END
)
</xsl:template>

<!-- Literal -->
<xsl:template match="Literal">
<xsl:value-of select="."/>
</xsl:template>
<!-- By default don't do anything -->
<xsl:template match="*">
</xsl:template>
<!--
Unary expressions where NULL considered as BLANK value(more like 0).
-->
<xsl:template match="OpNot">
NOT(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="BitNot">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
(1 - <xsl:apply-templates select="./*[1]"/>)
</xsl:when>
<xsl:otherwise>
COALESCE(1 - <xsl:apply-templates select="./*[1]"/>, 1)
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- UnaryMinus -->
<xsl:template match="UnaryMinus">(-<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<!-- Count Rows -->
<xsl:template match="OpCount">
COUNT(<xsl:apply-templates select="./*[1]"/> <xsl:apply-templates select="./*[2]"/>)
</xsl:template>
<!-- FUTURE: Avoid the redundant COUNT(DISTINCT ), either by using a subquery, or doing a projection on the results -->
<xsl:template match="OpDistinctCount">
(COUNT(DISTINCT <xsl:apply-templates select="./*[1]"/>) + MAX(CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN 1 ELSE 0 END))
</xsl:template>
<!-- FUTURE: Avoid the redundant COUNT(DISTINCT ), either by using a subquery, or doing a projection on the results -->
<xsl:template match="OpDistinctCountSkipBlank">
COUNT(DISTINCT <xsl:apply-templates select="./*[1]"/>)
</xsl:template>
<!--
Binary expressions where NULL considered as BLANK value(more like 0).
FUTURE: alleonov: maybe replace prefix Op with something else
-->
<!--Comparisons-->
<xsl:template match="OpGreater|OpLess|OpNotEqual|OpEqual|OpGreaterOrEqual|OpLessOrEqual">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='OpGreater'"> &gt; </xsl:when>
<xsl:when test="name()='OpLess'"> &lt; </xsl:when>
<xsl:when test="name()='OpNotEqual'"> &lt;&gt; </xsl:when>
<xsl:when test="name()='OpEqual'"> = </xsl:when>
<xsl:when test="name()='OpGreaterOrEqual'"> &gt;= </xsl:when>
<xsl:when test="name()='OpLessOrEqual'"> &lt;= </xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:when test="@Op1Type = 'String'">COALESCE(<xsl:apply-templates select="./*[1]"/>, '')</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">COALESCE(<xsl:apply-templates select="./*[1]"/>, <xsl:call-template name="print-datetime-origin-value"/>)</xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:when test="@Op2Type = 'String'">COALESCE(<xsl:apply-templates select="./*[2]"/>, '')</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">COALESCE(<xsl:apply-templates select="./*[2]"/>, <xsl:call-template name="print-datetime-origin-value"/>)</xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
(<xsl:value-of select="$Op1"/> <xsl:value-of select="$operator"/> <xsl:value-of select="$Op2"/>)
</xsl:template>
<!-- OpIs-->
<xsl:template match="OpIs">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' or @Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/>)
</xsl:when>
<xsl:otherwise>
<!--It's illegal to repeat query parameters more than once, so we can use only column references here.-->
(<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> OR <xsl:apply-templates select="./*[1]"/> IS NULL AND <xsl:apply-templates select="./*[2]"/> IS NULL)
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictGreater-->
<xsl:template match="OpStrictGreater">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 1)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 1)</xsl:when>
<xsl:otherwise>((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END END) = 1)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictLess-->
<xsl:template match="OpStrictLess">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 1)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 1)</xsl:when>
<xsl:otherwise>((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END END) = 1)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictLessOrEqual-->
<xsl:template match="OpStrictLessOrEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &lt;= <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 0)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 0)</xsl:when>
<xsl:otherwise>((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END END) = 0)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictGreaterOrEqual-->
<xsl:template match="OpStrictGreaterOrEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &gt;= <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 0)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 0)</xsl:when>
<xsl:otherwise>((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[2]"/> &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END END) = 0)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictNotEqual-->
<xsl:template match="OpStrictNotEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &lt;&gt; <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN 0 ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 0)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN 0 ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 0)</xsl:when>
<xsl:otherwise>((CASE WHEN <xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> OR (<xsl:apply-templates select="./*[1]"/> IS NULL AND <xsl:apply-templates select="./*[2]"/> IS NULL) THEN 1 ELSE 0 END) = 0)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictEqual-->
<xsl:template match="OpStrictEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'"><xsl:call-template name="print-datetime-origin-value"/></xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN 0 ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 1)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN 0 ELSE CASE WHEN <xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> THEN 1 ELSE 0 END END) = 1)</xsl:when>
<xsl:otherwise>((CASE WHEN <xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> OR (<xsl:apply-templates select="./*[1]"/> IS NULL AND <xsl:apply-templates select="./*[2]"/> IS NULL) THEN 1 ELSE 0 END) = 1)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpAdd-->
<xsl:template match="OpAdd">
<xsl:variable name="Op2Days">
<xsl:choose>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="OpDateTimeToFloat">
<xsl:with-param name="value-node"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise><xsl:apply-templates select="./*[2]"/></xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op1Days">
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="OpDateTimeToFloat">
<xsl:with-param name="value-node"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise><xsl:apply-templates select="./*[1]"/></xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime' and @Op1Nullable = 'false'">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'">
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value" select="./*[1]"/>
<xsl:with-param name="days-value"><xsl:value-of select="$Op2Days"/></xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
(CASE WHEN (<xsl:value-of select="$Op2Days"/>) IS NULL THEN <xsl:apply-templates select="./*[1]"/> ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
<xsl:with-param name="days-value"><xsl:value-of select="$Op2Days"/></xsl:with-param>
</xsl:call-template>
END)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="@Op2Type = 'Datetime' and @Op2Nullable = 'false'">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value" select="./*[2]"/>
<xsl:with-param name="days-value" select="./*[1]"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
(CASE WHEN (<xsl:value-of select="$Op1Days"/>) IS NULL THEN <xsl:apply-templates select="./*[2]"/> ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
<xsl:with-param name="days-value"><xsl:value-of select="$Op1Days"/></xsl:with-param>
</xsl:call-template>
END)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:choose>
<xsl:when test="@Op2Type = 'Datetime'">
(CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN <xsl:apply-templates select="./*[2]"/> ELSE CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN <xsl:apply-templates select="./*[1]"/> ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
<xsl:with-param name="days-value">
<xsl:call-template name="OpDateTimeToFloat">
<xsl:with-param name="value-node"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
</xsl:call-template>
</xsl:with-param>
</xsl:call-template>
END
END)
</xsl:when>
<xsl:otherwise>
(CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL
THEN
<xsl:call-template name="OpFloatToDateTime">
<xsl:with-param name="value-node"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
</xsl:call-template>
<xsl:choose>
<xsl:when test="Op2Nullable = 'false'">
ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
<xsl:with-param name="days-value"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
ELSE
CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN <xsl:apply-templates select="./*[1]"/>
ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
<xsl:with-param name="days-value"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
</xsl:call-template>
END
</xsl:otherwise>
</xsl:choose>
END)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
(CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL
THEN
<xsl:call-template name="OpFloatToDateTime">
<xsl:with-param name="value-node"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
</xsl:call-template>
<xsl:choose>
<xsl:when test="Op1Nullable = 'false'">
ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
<xsl:with-param name="days-value"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
ELSE
CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN <xsl:apply-templates select="./*[2]"/>
ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
<xsl:with-param name="days-value"><xsl:apply-templates select="./*[1]"/></xsl:with-param>
</xsl:call-template>
END
</xsl:otherwise>
</xsl:choose>
END)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> + <xsl:apply-templates select="./*[2]"/>)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">
COALESCE(<xsl:apply-templates select="./*[1]"/> + <xsl:apply-templates select="./*[2]"/>, <xsl:apply-templates select="./*[1]"/>)
</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">
COALESCE(<xsl:apply-templates select="./*[1]"/> + <xsl:apply-templates select="./*[2]"/>, <xsl:apply-templates select="./*[2]"/>)
</xsl:when>
<xsl:otherwise>
COALESCE(<xsl:apply-templates select="./*[1]"/> + <xsl:apply-templates select="./*[2]"/>, <xsl:apply-templates select="./*[1]"/>, <xsl:apply-templates select="./*[2]"/>)
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpSubtract -->
<xsl:template match="OpSubtract">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="OpDateTimeToFloat">
<xsl:with-param name="value-node"><xsl:apply-templates select="./*[2]"/></xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise><xsl:apply-templates select="./*[2]"/></xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'">
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value">COALESCE(<xsl:apply-templates select="./*[1]"/>, <xsl:call-template name="print-datetime-origin-value"/>)</xsl:with-param>
<xsl:with-param name="days-value">(0.0 - <xsl:value-of select="$Op2"/>)</xsl:with-param>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
(CASE WHEN <xsl:apply-templates select="./*[2]"/> IS NULL THEN <xsl:apply-templates select="./*[1]"/> ELSE
<xsl:call-template name="OpAddDays">
<xsl:with-param name="date-value">COALESCE(<xsl:apply-templates select="./*[1]"/>, <xsl:call-template name="print-datetime-origin-value"/>)</xsl:with-param>
<xsl:with-param name="days-value">(0.0 - 	<xsl:value-of select="$Op2"/>)</xsl:with-param>
</xsl:call-template>
END)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> - <xsl:value-of select="$Op2"/>)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">
COALESCE(<xsl:apply-templates select="./*[1]"/> - <xsl:value-of select="$Op2"/>, <xsl:apply-templates select="./*[1]"/>)
</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">
COALESCE(<xsl:apply-templates select="./*[1]"/> - <xsl:value-of select="$Op2"/>, -<xsl:value-of select="$Op2"/>)
</xsl:when>
<xsl:otherwise>
COALESCE(<xsl:apply-templates select="./*[1]"/> - <xsl:value-of select="$Op2"/>, <xsl:apply-templates select="./*[1]"/>, -<xsl:value-of select="$Op2"/>)
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpDivide	-->
<xsl:template match="OpDivide">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op1Type = 'Currency' and @Op2Type != 'Currency'">
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Currency'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Double'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> / <xsl:value-of select="$Op2"/>)
</xsl:when>
<xsl:otherwise>
(<xsl:apply-templates select="./*[1]"/> / COALESCE(<xsl:value-of select="$Op2"/>, 0))
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpMultiply	-->
<xsl:template match="OpMultiply">
<xsl:choose>
<xsl:when test="@Op1Type = 'Currency' and @Op2Type = 'Currency'">
(<xsl:apply-templates select="./*[1]"/> *
(<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="'Currency'"/>
<xsl:with-param name="target-type" select="'Double'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>))
</xsl:when>
<xsl:when test="@Op1Type = 'Double' and @Op2Type = 'Currency' or @Op2Type = 'Double' and @Op1Type = 'Currency'">
<!--FUTURE: RT: it's impossible to use <xsl:call-template name="OpCast"/> here,
so using direct cast. It gives us desired result here.					-->
CAST(<xsl:apply-templates select="./*[1]"/> * <xsl:apply-templates select="./*[2]"/> AS DECIMAL(19,4))
</xsl:when>
<xsl:otherwise>
(<xsl:apply-templates select="./*[1]"/> * <xsl:apply-templates select="./*[2]"/>)
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpSafeDivide	-->
<xsl:template match="OpSafeDivide">
<!-- ***** This part is from OpDivide above ***** -->
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op1Type = 'Currency' and @Op2Type != 'Currency'">
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Currency'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Double'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<!-- ***** End of part from OpDivide. ***** -->
(CASE
WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN NULL
ELSE
CASE WHEN <xsl:value-of select="$Op2"/> IS NULL OR <xsl:value-of select="$Op2"/> = 0 THEN <xsl:apply-templates select="./*[3]"/> ELSE <xsl:apply-templates select="./*[1]"/> / <xsl:value-of select="$Op2"/> END
END)
</xsl:template>
<!-- OpOr|OpAnd -->
<xsl:template match="OpOr|OpAnd">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='OpOr'"> OR </xsl:when>
<xsl:when test="name()='OpAnd'"> AND </xsl:when>
</xsl:choose>
</xsl:variable>
(<xsl:apply-templates select="./*[1]"/> <xsl:value-of select="$operator"/> <xsl:apply-templates select="./*[2]"/>)
</xsl:template>
<!-- Print a schema object -->
<xsl:template name="build-quoted-schema-object">
<xsl:param name="schema-object-node" select="."/>

<xsl:variable name="unquoted-schema">
<xsl:value-of select="$schema-object-node/Schema"/>
</xsl:variable>
<xsl:variable name="schema">
<xsl:apply-templates select="$schema-object-node/Schema"/>
</xsl:variable>
<xsl:variable name="table">
<xsl:apply-templates select="$schema-object-node/Name"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$unquoted-schema = ''">
<xsl:value-of select="$table"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat($schema,'.', $table)"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- Convert an identifier to the OLEDB quotation form -->
<xsl:template name="quote-identifier">
<xsl:param name="identifier" select="."/>

<xsl:value-of select="$IdentifierStartQuotingCharacter"/>
<xsl:call-template name="normalize-entity-aux">
<xsl:with-param name="entity" select="$identifier"/>
<xsl:with-param name="end-quoting-char" select="$IdentifierEndQuotingCharacter"/>
</xsl:call-template>
<xsl:value-of select="$IdentifierEndQuotingCharacter"/>
</xsl:template>
<!-- Convert a string to the string quotation form -->
<xsl:template name="quote-string">
<xsl:param name="string" select="."/>
<xsl:param name="unicode" select="."/>
<xsl:choose>
<xsl:when test="$unicode != 'false'"><xsl:value-of select="$UnicodeStringPrefix"/></xsl:when>
</xsl:choose>
<xsl:value-of select="$StringQuotingCharacter"/>
<xsl:call-template name="normalize-entity-aux">
<xsl:with-param name="entity" select="$string"/>
<xsl:with-param name="end-quoting-char" select="$StringQuotingCharacter"/>
</xsl:call-template>
<xsl:value-of select="$StringQuotingCharacter"/>
</xsl:template>
<!-- Convert an entity to the quotation form (recursive, aux)  by
duplicating the end quoting character -->
<xsl:template name="normalize-entity-aux">
<xsl:param name="entity"/>
<xsl:param name="end-quoting-char"/>

<xsl:choose>
<xsl:when test="contains($entity, $end-quoting-char)">
<xsl:value-of select="substring-before($entity, $end-quoting-char)"/>
<xsl:value-of select="$end-quoting-char"/>
<xsl:value-of select="$end-quoting-char"/>
<xsl:call-template name="normalize-entity-aux">
<xsl:with-param name="entity" select="substring-after($entity, $end-quoting-char)"/>
<xsl:with-param name="end-quoting-char" select="$end-quoting-char"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$entity"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- Print the children list -->
<xsl:template name="print-children-list">
<xsl:param name="value-node" select="."/>
<xsl:param name="operator" select="','"/>
<xsl:param name="prefix" select="''"/>

<xsl:call-template name="print-list">
<xsl:with-param name="value-node" select="$value-node/*"/>
<xsl:with-param name="operator" select="$operator"/>
<xsl:with-param name="prefix" select="$prefix"/>
</xsl:call-template>
</xsl:template>
<!-- Print a list                                                     -->
<xsl:template name="print-list">
<xsl:param name="operator" select="','"/>
<xsl:param name="value-node" select="."/>
<xsl:param name="prefix" select="''"/>

<xsl:for-each select="$value-node">
<xsl:call-template name="print-element-optional-prefix">
<xsl:with-param name="value-node" select="."/>
<xsl:with-param name="prefix" select="$prefix"/>
</xsl:call-template>
<xsl:if test="position()!=last()">
<xsl:value-of select="$operator"/>
</xsl:if>
</xsl:for-each>
</xsl:template>
<!-- Print a list of pairs connected by = -->
<xsl:template name="print-children-pair-list">
<xsl:param name="value-node1" select="."/>
<xsl:param name="value-node2" select="."/>
<xsl:param name="prefix1" select="''"/>
<xsl:param name="prefix2" select="''"/>
<xsl:param name="operator" select="' AND '"/>
<xsl:param name="connector" select="' = '"/>

<xsl:for-each select="$value-node1/*">
<xsl:call-template name="print-element-optional-prefix">
<xsl:with-param name="value-node" select="."/>
<xsl:with-param name="prefix" select="$prefix1"/>
</xsl:call-template>
<xsl:value-of select="$connector"/>
<xsl:call-template name="print-element-optional-prefix">
<xsl:with-param name="value-node" select="$value-node2/*[position()]"/>
<xsl:with-param name="prefix" select="$prefix2"/>
</xsl:call-template>
<xsl:if test="position()!=last()">
<xsl:value-of select="$operator"/>
</xsl:if>
</xsl:for-each>
</xsl:template>
<!-- Print an element giving it an optional prefix -->
<xsl:template name="print-element-optional-prefix">
<xsl:param name="value-node" select="."/>
<xsl:param name="prefix" select="''"/>

<xsl:for-each select="$value-node">
<xsl:variable name="element">
<xsl:apply-templates select="."/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$prefix = ''">
<xsl:value-of select="$element"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat($prefix, '.', $element)"/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:template>
<!-- Get the value of a parameter ref for the query -->
<xsl:template name="print-non-parametric-parameter-ref">
<xsl:param name="parameter-reference"/>

<xsl:variable name="reference"><xsl:value-of select="$parameter-reference/@ref"/></xsl:variable>
<xsl:call-template name="print-non-parametric-parameter">
<xsl:with-param name="parameter" select="/Statement/Parameters/Parameter[@id=$reference]"/>
</xsl:call-template>
</xsl:template>
<!-- Get the value of a parameter ref for the query -->
<xsl:template name="print-non-parametric-parameter">
<xsl:param name="parameter"/>

<xsl:variable name="db-type"><xsl:value-of select="$parameter/@DBTYPE"/></xsl:variable>
<xsl:variable name="value"><xsl:value-of select="$parameter/text()"/></xsl:variable>
<xsl:choose>
<xsl:when test="$db-type = 'DBTYPE_BSTR'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_WSTR'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_STR'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/><xsl:with-param name="unicode" select="false"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_BOOL'">CAST(<xsl:value-of select="$value"/> AS BIT)</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I1'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I2'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I4'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I8'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI1'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI2'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI4'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI8'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_R4'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_R8'"><xsl:value-of select="$value"/></xsl:when>
<!--Here we are relying on implicit casting from string to DateTime or TimeStamp on the data-source because for SQL ODBC provider there is a bug in the CAST('literal' AS TIMESTAMP) where it uses non-ANSI Datatype mapping.-->
<xsl:when test="$db-type = 'DBTYPE_DATE'"><xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBDATE'">CAST( <xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string" select="$value"/></xsl:call-template> AS DATE)</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBTIME'">CAST( <xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string" select="$value"/></xsl:call-template> AS TIME)</xsl:when>
<!--Here we are relying on implicit casting from string to DateTime or TimeStamp on the data-source because for SQL ODBC provider there is a bug in the CAST('literal' AS TIMESTAMP) where it uses non-ANSI Datatype mapping.-->
<xsl:when test="$db-type = 'DBTYPE_DBTIMESTAMP'"><xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_CY'">CAST( <xsl:call-template name="quote-string"><xsl:with-param name="unicode" select="false"/><xsl:with-param name="string" select="$value"/></xsl:call-template> AS DECIMAL(19,4))</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_VARIANT'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_GUID'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_ByteArray'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DECIMAL'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_EMPTY'">NULL</xsl:when>
</xsl:choose>
</xsl:template>
<!-- Types -->
<xsl:template match="Type">
<xsl:variable name="type-val"><xsl:value-of select="normalize-space(./text())"/></xsl:variable>
<xsl:choose>
<xsl:when test="$type-val = 'DBTYPE_BSTR'"> NCHAR VARYING </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_WSTR'"> NCHAR VARYING </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_STR'"> VARCHAR </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_BOOL'"> BIT </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I1'"> DECIMAL(3,0) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I2'"> SMALLINT </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I4'"> INTEGER </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I8'"> DECIMAL(19,0) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI1'"> DECIMAL(3,0) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI2'"> SMALLINT </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI4'"> INTEGER </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI8'"> DECIMAL(19,0) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_R4'"> REAL </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_R8'"> FLOAT(53) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_DATE'"> TIMESTAMP </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_DBTIMESTAMP'"> TIMESTAMP </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_CY'"> DECIMAL(19,4) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_VARIANT'"><xsl:message terminate="yes">ODBC cartridge error: OpCast: ResultType is not specified</xsl:message></xsl:when>
<xsl:when test="$type-val = 'DBTYPE_GUID'"> VARCHAR(36) </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_ByteArray'"> BIT VARYING </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_DECIMAL'"> DECIMAL(19,4)</xsl:when>
</xsl:choose>
<xsl:apply-templates select="./Size"/>
<xsl:apply-templates select="./Precision"/>
<xsl:apply-templates select="./Scale"/>
</xsl:template>
</xsl:stylesheet>
