<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" version="1.0" xmlns:mssqlcrt="urn:sql-microsoft-com:sqlcrt" xmlns:mssqldbg="urn:sql-microsoft-com:sqldbg">
<xsl:output method="xml" indent="yes"/>

<!-- This ALWAYS GENERATED file contains the definitions for the cartridges
Microsoft Cartridge Interfaces (Analysis Services 2005)
(C) Copyright 1988 - 2003 By Microsoft Corporation.      -->
<!-- Area of Custom parametrizations: these may be modified by customers for specific query customizations  -->
<!-- post-select-query-hint will append the customer-defined string at the end of the generated SELECT statement - e.g. WITH UR -->
<xsl:param name="post-select-query-hint"></xsl:param>

<!-- SAP Hana pluggable cartridge                              -->

<!-- Area of STANDARD parametrizations: these are externally passed   -->
<xsl:param name="in_CanUseParams">yes</xsl:param>
<xsl:param name="in_IdentStartQuotingCharacter">"</xsl:param>
<xsl:param name="in_IdentEndQuotingCharacter">"</xsl:param>
<xsl:param name="in_UnicodeStringPrefix">N</xsl:param>
<xsl:param name="in_StringQuotingCharacter">'</xsl:param>

<!-- Area of CORE parametrizations: These are externally checked      -->
<mssqlcrt:provider type="prefix" managed="yes" native="yes">HDB</mssqlcrt:provider>
<mssqlcrt:provider type="prefix" managed="yes" native="yes">TEXT</mssqlcrt:provider>
<mssqlcrt:parameter-style native="unnamed" managed="named"/>
<mssqlcrt:dq-datetime-format>YYYY-MM-DD HH:MM:SS</mssqlcrt:dq-datetime-format>

<mssqlcrt:capabilities>
<mssqlcrt:supports-datepart-year/>
<mssqlcrt:supports-datepart-quarter/>
<mssqlcrt:supports-datepart-month/>
<mssqlcrt:supports-datepart-dayofyear/>
<mssqlcrt:supports-datepart-day/>
<mssqlcrt:supports-datepart-week/>
<mssqlcrt:supports-datepart-dayofweek/>
<mssqlcrt:supports-datepart-hour/>
<mssqlcrt:supports-datepart-minute/>
<mssqlcrt:supports-datepart-second/>
<mssqlcrt:supports-datepart-millisecond/>
<mssqlcrt:supports-multiple-distinct-count/>
<mssqlcrt:supports-update/>
<mssqlcrt:supports-insert/>
<mssqlcrt:supports-subselect/>
<mssqlcrt:supports-table-alias/>
<mssqlcrt:supports-column-alias/>
<mssqlcrt:supports-cast/>
<mssqlcrt:supports-remote-query/>
<mssqlcrt:supports-top-clause/>
<mssqlcrt:supports-union/>
<mssqlcrt:supports-union-all/>
<mssqlcrt:supports-datetime-format>YYYY-MM-DD HH:MM:SS</mssqlcrt:supports-datetime-format>
<mssqlcrt:supports-fast-writeback>TABLOCK,FIRE_TRIGGERS</mssqlcrt:supports-fast-writeback>
<mssqlcrt:supports-recursive-select>1</mssqlcrt:supports-recursive-select>
<mssqlcrt:supports-materialized-view>2</mssqlcrt:supports-materialized-view>
<mssqlcrt:supports-real-time/>
<mssqlcrt:supports-joins/>
<mssqlcrt:supports-apply/>
<mssqlcrt:supports-distinct-count/>
<mssqlcrt:supports-top-skip/>
<mssqlcrt:supports-top/>
<mssqlcrt:supports-not-operator/>
<!-- mssqlcrt:supports-materialized-view-prevalidation -->
<!-- <mssqlcrt:supports-params/> -->

<mssqlcrt:supports-weeknum-return-type>21</mssqlcrt:supports-weeknum-return-type>
<mssqlcrt:pattern-search-expression-type>PCRE</mssqlcrt:pattern-search-expression-type>

<mssqlcrt:limit-materialized-view-column-count>16</mssqlcrt:limit-materialized-view-column-count>
<mssqlcrt:limit-table-identifier-length>64</mssqlcrt:limit-table-identifier-length>
<mssqlcrt:limit-column-identifier-length>64</mssqlcrt:limit-column-identifier-length>
<mssqlcrt:limit-parameter-count>2100</mssqlcrt:limit-parameter-count>
<mssqlcrt:limit-in-operator-list-size>2100</mssqlcrt:limit-in-operator-list-size>
<mssqlcrt:limit-temptable-row-count>0</mssqlcrt:limit-temptable-row-count>
<mssqlcrt:limit-batch-insert-count>1000</mssqlcrt:limit-batch-insert-count>

<!-- Map from MSDAInitialize connection string to SQLOLEDB connection string -->
<mssqlcrt:remote-connection-string-mappings>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Provider</mssqlcrt:datasource-property>
<mssqlcrt:remote-property></mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Data Source</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>Server</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Initial Catalog</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>Database</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>User ID</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>UID</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Password</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>PWD</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:remote-connection-string-mapping>
<mssqlcrt:datasource-property>Integrated Security=SSPI</mssqlcrt:datasource-property>
<mssqlcrt:remote-property>Trusted_Connection=yes</mssqlcrt:remote-property>
</mssqlcrt:remote-connection-string-mapping>
</mssqlcrt:remote-connection-string-mappings>
</mssqlcrt:capabilities>

<mssqlcrt:schema-classes>
<mssqlcrt:schema-class>
<mssqlcrt:managed-provider>System.Data.SqlClient</mssqlcrt:managed-provider>
<mssqlcrt:type>Microsoft.DataWarehouse.Design.SqlSchema, Microsoft.DataWarehouse.AS</mssqlcrt:type>
<mssqlcrt:query-designer>
<mssqlcrt:type>Microsoft.DataWarehouse.Controls.SqlClientQueryDesigner, Microsoft.DataWarehouse.AS</mssqlcrt:type>
</mssqlcrt:query-designer>
</mssqlcrt:schema-class>
<mssqlcrt:schema-class>
<mssqlcrt:managed-provider>System.Data.OleDb</mssqlcrt:managed-provider>
<mssqlcrt:type>Microsoft.DataWarehouse.Design.OleDbSchema, Microsoft.DataWarehouse.AS</mssqlcrt:type>
<mssqlcrt:query-designer>
<mssqlcrt:type>Microsoft.DataWarehouse.Controls.OleDbQueryDesigner, Microsoft.DataWarehouse.AS</mssqlcrt:type>
</mssqlcrt:query-designer>
</mssqlcrt:schema-class>
<mssqlcrt:schema-class>
<mssqlcrt:managed-provider>System.Data.Odbc</mssqlcrt:managed-provider>
<mssqlcrt:type>Microsoft.DataWarehouse.Design.OdbcSchema, Microsoft.DataWarehouse.AS</mssqlcrt:type>
</mssqlcrt:schema-class>
</mssqlcrt:schema-classes>

<mssqlcrt:capabilities>
<!-- MATH/TRIG Functions -->
<mssqlcrt:supports-func>ABS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ACOS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ASIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ATAN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ACOT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>CEILING</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COSH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>CURRENCY</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DEGREES</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DIVIDE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EXP</mssqlcrt:supports-func>
<mssqlcrt:supports-func>FLOOR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>INT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ISO.CEILING</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LOG</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LOG10</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MAX</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MOD</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MROUND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>POWER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>QUOTIENT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>RADIANS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ROUND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ROUNDDOWN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ROUNDUP</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SIGN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SIN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SINH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SQRT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SQRTPI</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TAN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TANH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TRUNC</mssqlcrt:supports-func>

<!-- INFO Functions -->
<mssqlcrt:supports-func>CONTAINSROW</mssqlcrt:supports-func>
<mssqlcrt:supports-func>ISBLANK</mssqlcrt:supports-func>

<!-- LOGICAL Functions -->
<mssqlcrt:supports-func>AND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>IF</mssqlcrt:supports-func>
<mssqlcrt:supports-func>IF.EAGER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>NOT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>OR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SWITCH</mssqlcrt:supports-func>

<!-- DATETIME Functions -->
<mssqlcrt:supports-func>DAY</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EDATE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>EOMONTH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>HOUR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MONTH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MINUTE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>QUARTER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SECOND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>WEEKDAY</mssqlcrt:supports-func>
<mssqlcrt:supports-func>WEEKNUM</mssqlcrt:supports-func>
<mssqlcrt:supports-func>YEAR</mssqlcrt:supports-func>

<!-- String Functions -->
<mssqlcrt:supports-func>COMBINEVALUES</mssqlcrt:supports-func>
<mssqlcrt:supports-func>CONCATENATE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DATEVALUE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>FIND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LEFT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LEN</mssqlcrt:supports-func>
<mssqlcrt:supports-func>LOWER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MID</mssqlcrt:supports-func>
<mssqlcrt:supports-func>RIGHT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SEARCH</mssqlcrt:supports-func>
<mssqlcrt:supports-func>SUBSTITUTE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TIMEVALUE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>TRIM</mssqlcrt:supports-func>
<mssqlcrt:supports-func>UNICHAR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>UNICODE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>UPPER</mssqlcrt:supports-func>
<mssqlcrt:supports-func>VALUE</mssqlcrt:supports-func>

<!-- Filter Functions -->
<mssqlcrt:supports-func>KEEPFILTERS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>RELATED</mssqlcrt:supports-func>
<mssqlcrt:supports-func>USERELATIONSHIP</mssqlcrt:supports-func>

<!-- Aggregate Functions -->
<mssqlcrt:supports-func>SUM</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MINA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>MAXA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>AVERAGE</mssqlcrt:supports-func>
<mssqlcrt:supports-func>AVERAGEA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>STDEV.S</mssqlcrt:supports-func>
<mssqlcrt:supports-func>STDEV.P</mssqlcrt:supports-func>
<mssqlcrt:supports-func>VAR.S</mssqlcrt:supports-func>
<mssqlcrt:supports-func>VAR.P</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COUNT</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COUNTA</mssqlcrt:supports-func>
<mssqlcrt:supports-func>COUNTROWS</mssqlcrt:supports-func>
<mssqlcrt:supports-func>DISTINCTCOUNT</mssqlcrt:supports-func>

<!-- Engineering Functions -->
<mssqlcrt:supports-func>BITAND</mssqlcrt:supports-func>
<mssqlcrt:supports-func>BITOR</mssqlcrt:supports-func>
<mssqlcrt:supports-func>BITXOR</mssqlcrt:supports-func>

</mssqlcrt:capabilities>

<!-- Area of internal parametrizations                                -->
<!-- overrideOfUseParams:
yes      = use always parametric queries
no       = never use parametric queries
nosubsel = use as yes, but not on subselects
auto     = use the value of in_CanUseParams to determine     -->
<xsl:variable name="overrideOfUseParams">auto</xsl:variable>
<!-- shouldProduceDebug:
yes      = produce debug information
no       = do not produce debug information                  -->
<xsl:variable name="shouldProduceDebug">yes</xsl:variable>
<mssqlcrt:sourceprovidertypename>
<supportedtypes>
<date>DATE</date>
<time>DATE</time>
<seconddate>DATE</seconddate>
<timestamp>DATE</timestamp>
<tinyint>I8</tinyint>
<smallint>I8</smallint>
<integer>I8</integer>
<bigint>I8</bigint>
<smalldecimal>R8</smalldecimal>
<decimal>R8</decimal>
<real>R8</real>
<double>R8</double>
<varchar>STR</varchar>
<nvarchar>STR</nvarchar>
<alphanum>STR</alphanum>
<shorttext>STR</shorttext>
<varbinary>STR</varbinary>
<blob/>
<clob/>
<nclob/>
<text>STR</text>
<array/>
</supportedtypes>
<unicode>
<nvarchar/>
<nclob/>
</unicode>
<date format="yyyy-mm-dd"> <!-- TODO: SAP HANA accepts yyyymmdd so 2 chars saving? -->
<date/>
</date>
<time format="hh:mm:ss">
<time/>
</time>
<agg_upcast>
<tinyint/>
<smallint/>
<integer/>
</agg_upcast>
<max_nvarchar_len value="4000"/>
</mssqlcrt:sourceprovidertypename>

<!-- Area of global variables initializations                         -->
<xsl:variable name="UseParams">
<xsl:choose>
<xsl:when test="normalize-space($overrideOfUseParams) = 'yes' or (normalize-space($overrideOfUseParams) = 'auto' and normalize-space($in_CanUseParams)='yes')">yes</xsl:when>
<xsl:when test="normalize-space($overrideOfUseParams) = 'nosubsel'">nosubsel</xsl:when>
<xsl:otherwise>no</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="ProduceDebug" select="$shouldProduceDebug"/>
<xsl:variable name="IdentifierStartQuotingCharacter" select="normalize-space($in_IdentStartQuotingCharacter)"/>
<xsl:variable name="IdentifierEndQuotingCharacter" select="normalize-space($in_IdentEndQuotingCharacter)"/>
<xsl:variable name="UnicodeStringPrefix" select="normalize-space($in_UnicodeStringPrefix)"/>
<xsl:variable name="StringQuotingCharacter" select="normalize-space($in_StringQuotingCharacter)"/>

<!-- Generated statement packaging                                    -->
<xsl:template match="/">
<xsl:element name="Statement">
<!-- Generate query                                           -->
<xsl:element name="Text">
<xsl:apply-templates select="./Statement/*[1]"/>
</xsl:element>

<!-- Generate parameters                                      -->
<xsl:if test="(./Statement[not(@DQInlineParams)]) and count(./Statement/Parameters/Parameter)!=0 and ((normalize-space($UseParams)='yes') or (normalize-space($UseParams)='nosubsel'))">
<xsl:element name="Parameters">
<xsl:choose>
<xsl:when test="/Statement/*[1]//Parameter/@ParamName">
<xsl:for-each select="./Statement/Parameters/Parameter">
<xsl:element name="Parameter">
<xsl:attribute name="ref">
<xsl:value-of select="./@id"/>
</xsl:attribute>
</xsl:element>
</xsl:for-each>
</xsl:when>
<xsl:otherwise>
<xsl:for-each select="./Statement/*[1]//Parameter">
<xsl:element name="Parameter">
<xsl:attribute name="ref">
<xsl:value-of select="./@ref"/>
</xsl:attribute>
</xsl:element>
</xsl:for-each>
</xsl:otherwise>
</xsl:choose>
</xsl:element>
</xsl:if>

<!-- Generate debug info                                      -->
<xsl:if test="$ProduceDebug='yes'">
<xsl:element name="mssqldbg:DebugInfo">
<xsl:element name="mssqldbg:GenerateParametricInfo">
<xsl:attribute name="mssqldbg:Value">
<xsl:value-of select="$UseParams"/>
</xsl:attribute>
<xsl:element name="mssqldbg:External">
<xsl:value-of select="$in_CanUseParams"/>
</xsl:element>
<xsl:element name="mssqldbg:Internal">
<xsl:value-of select="$overrideOfUseParams"/>
</xsl:element>
</xsl:element>
</xsl:element>
</xsl:if>

</xsl:element>
</xsl:template>

<!-- Union statement                                                  -->
<xsl:template match="Union">
<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert'">
(
</xsl:if>
<xsl:call-template name="print-children-list">
<xsl:with-param name="operator" select="' UNION '"/>
</xsl:call-template>
<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert'">
)
</xsl:if>
</xsl:template>

<!-- Union All statement                                                  -->
<xsl:template match="UnionAll">
<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert'">
(
</xsl:if>
<xsl:call-template name="print-children-list">
<xsl:with-param name="operator" select="' UNION ALL '"/>
</xsl:call-template>
<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert'">
)
</xsl:if>
</xsl:template>

<!-- Top clause																											 -->
<xsl:template match="Top">
LIMIT <xsl:apply-templates select="./*[1]"/> <xsl:apply-templates select="./Offset"/>
</xsl:template>

<xsl:template match="Limit">
LIMIT <xsl:apply-templates select="./*[1]"/> <xsl:apply-templates select="./Offset"/>
</xsl:template>

<xsl:template match="Offset">
OFFSET <xsl:apply-templates select="./*[1]"/>
</xsl:template>

<!-- Select statement                                                 -->
<xsl:template match="Select">
<xsl:choose>
<xsl:when test="count(./ColumnExpressions/IsValidForIndexing) != 0">
SELECT OBJECTPROPERTY( object_id('<xsl:apply-templates select="./Sources/View"/>'), 'isindexable' )
</xsl:when>
<xsl:when test="name(..) != 'Statement' and count(.//Recursion) != 0">
<xsl:apply-templates select="./Sources/As/*[2]"/>
</xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="name(..) != 'Statement' and name(..) != 'Insert' and name(..) != 'Union' and name(..) != 'UnionAll'">
(
</xsl:when>
<xsl:when test="name(..) = 'Statement' and count(.//Recursion) != 0">
; WITH
<xsl:for-each select=".//Recursion">
<xsl:apply-templates select="."/>
<xsl:if test="position()!=last()">, </xsl:if>
</xsl:for-each>
</xsl:when>
</xsl:choose>
SELECT <xsl:apply-templates select="./Distinct"/>
<xsl:apply-templates select="./ColumnExpressions"/>
<xsl:apply-templates select="./Sources"/>
<xsl:apply-templates select="./Where"/>
<xsl:apply-templates select="./GroupBy"/>
<xsl:apply-templates select="./OrderBy"/>
<xsl:apply-templates select="./Top"/>
<xsl:apply-templates select="./Limit"/>

<xsl:if test="name(..) = 'Statement'">
<xsl:text> </xsl:text><xsl:value-of select="$post-select-query-hint"/>
</xsl:if>
<xsl:if test="name(..) != 'Statement' and name(..) != 'Insert' and name(..) != 'Union' and name(..) != 'UnionAll'">
)
</xsl:if>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- Singleton clause                                                       -->
<xsl:template match="Singleton">
(SELECT <xsl:apply-templates select="./ColumnExpressions"/>
<xsl:text> ) </xsl:text>
</xsl:template>

<!-- Recursion fragment                                               -->
<xsl:template match="Recursion">
<xsl:variable name="cte-name">
<xsl:choose>
<xsl:when test="count(../Distinct) = 0 and name(../../..) != 'Union'">
[<xsl:value-of select="./Name"/>]
</xsl:when>
<xsl:otherwise>
[<xsl:value-of select="./Name"/>_e2__A9259451]
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="$cte-name"/>
( <xsl:apply-templates select="./ColumnExpressions"/> )
AS
(
SELECT
<xsl:call-template name="print-children-list">
<xsl:with-param name="value-node" select="./ColumnExpressions"/>
</xsl:call-template>
<xsl:apply-templates select="./Sources"/>
<xsl:apply-templates select="./Where"/>
UNION ALL
SELECT
<xsl:call-template name="print-children-list">
<xsl:with-param name="value-node" select="./ColumnExpressions"/>
<xsl:with-param name="prefix" select="'[e2__A9259451-8A3F-4821-A7F0-10C7E3632D25]'"/>
</xsl:call-template>
FROM <xsl:apply-templates select="./Sources/As/*[1]"/> AS [e2__A9259451-8A3F-4821-A7F0-10C7E3632D25], <xsl:value-of select="$cte-name"/>
WHERE
(
<xsl:call-template name="print-children-pair-list">
<xsl:with-param name="value-node1" select="./Child"/>
<xsl:with-param name="value-node2" select="./Parent"/>
<xsl:with-param name="prefix1" select="$cte-name"/>
<xsl:with-param name="prefix2" select="'[e2__A9259451-8A3F-4821-A7F0-10C7E3632D25]'"/>
</xsl:call-template>
)
AND
<xsl:call-template name="print-children-pair-list">
<xsl:with-param name="value-node1" select="./Child"/>
<xsl:with-param name="value-node2" select="./Child"/>
<xsl:with-param name="prefix1" select="$cte-name"/>
<xsl:with-param name="prefix2" select="'[e2__A9259451-8A3F-4821-A7F0-10C7E3632D25]'"/>
<xsl:with-param name="connector" select="'&lt;&gt;'"/>
</xsl:call-template>
)
<xsl:if test="count(../Distinct) != 0">
,<xsl:value-of select="./Name"/>
( <xsl:apply-templates select="./ColumnExpressions"/> )
AS (
SELECT * FROM <xsl:value-of select="$cte-name"/>
)
</xsl:if>
<xsl:if test="name(../../..) = 'Union'">
,<xsl:value-of select="./Name"/>
( <xsl:apply-templates select="./ColumnExpressions"/> )
AS (
SELECT * FROM <xsl:value-of select="$cte-name"/>
UNION
<xsl:apply-templates select="../../../*[2]"/>
)
</xsl:if>
</xsl:template>

<!-- Update statement                                                 -->
<xsl:template match="Update">
UPDATE <xsl:apply-templates select="./Target"/>
<xsl:apply-templates select="./Where"/>
</xsl:template>

<xsl:template match="CloneTable">
CREATE LOCAL TEMPORARY TABLE <xsl:apply-templates select="./CloneTableName"/>
<xsl:apply-templates select="./CloneColumnDefinitions"/>
</xsl:template>

<xsl:template match="CloneTableName">
"<xsl:value-of select="./text()"/>"
</xsl:template>

<xsl:template match="CloneColumnDefinition">
<xsl:apply-templates select="./SQLColumn/Column"/>
<xsl:apply-templates select="./Type"/>
</xsl:template>

<xsl:template match="CloneColumnDefinitions">
(<xsl:call-template name="print-children-list"/>)
</xsl:template>

<!-- Insert statement                                                 -->
<xsl:template match="Insert">
INSERT INTO <xsl:apply-templates select="./Target"/>
<xsl:apply-templates select="./Select"/>
<xsl:apply-templates select="./RowValues"/>
</xsl:template>

<xsl:template match="RowValues">
<xsl:call-template name="print-children-list">
<xsl:with-param name="operator" select="' UNION '"/>
</xsl:call-template>
</xsl:template>

<xsl:template match="RowValue">
select <xsl:call-template name="print-children-list"/> from dummy
</xsl:template>

<!-- Delete statement                                                 -->
<xsl:template match="Delete">
DELETE FROM <xsl:apply-templates select="./Target"/>
<xsl:apply-templates select="./Where"/>
</xsl:template>

<!-- Drop statement                                                   -->
<xsl:template match="Drop">
DROP <xsl:apply-templates select="./*"/>
</xsl:template>

<!-- Create statement                                                 -->
<xsl:template match="Create">
CREATE
<xsl:variable name="phase"><xsl:value-of select="./Phase"/></xsl:variable>
<xsl:choose>
<xsl:when test="number($phase)=1">
VIEW <xsl:apply-templates select="./View"/> ( <xsl:apply-templates select="./*[4]"/>, [COUNT_BIG_7673aff6-2445-4ef6-a4c9-7bf3d93bd42a] ) WITH SCHEMABINDING AS <xsl:apply-templates select="./*[5]"/>
</xsl:when>
<xsl:when test="number($phase)=2">
UNIQUE CLUSTERED INDEX <xsl:apply-templates select="./Index"/> ON <xsl:apply-templates select="./View"/> ( <xsl:apply-templates select="./*[4]"/> )
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates select="./*[1]"/>
<xsl:choose>
<xsl:when test="name(./*[1]) = 'Table'"> ( <xsl:apply-templates select="./*[2]"/> )</xsl:when>
</xsl:choose>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- Remote query (OPENROWSET)                                        -->
<xsl:template match="RemoteQuery">
OPENROWSET
(
<xsl:call-template name="quote-string"><xsl:with-param name="string" select="./Provider"/></xsl:call-template>,
<xsl:choose>
<xsl:when test="./DataSource">
<xsl:call-template name="quote-string"><xsl:with-param name="string" select="./DataSource"/></xsl:call-template>;<xsl:call-template name="quote-string"><xsl:with-param name="string" select="./UserName"/></xsl:call-template>;<xsl:call-template name="quote-string"><xsl:with-param name="string" select="./Password"/></xsl:call-template>,
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="quote-string"><xsl:with-param name="string" select="./ConnectionString"/></xsl:call-template>,
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="quote-string"><xsl:with-param name="string" select="./*[last()]"/></xsl:call-template>
)
</xsl:template>

<xsl:template match="Distinct">
DISTINCT
</xsl:template>

<xsl:template match="As">
<xsl:choose>
<xsl:when test="count(.//Recursion) != 0">
<xsl:apply-templates select="./*[2]"/>
</xsl:when>
<xsl:otherwise><xsl:apply-templates select="./*[1]"/> AS <xsl:apply-templates select="./*[2]"/></xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Sources">
FROM <xsl:choose>
<xsl:when test="count(./Join) != 0 or count(./Apply) != 0 or count(./CrossJoin)!= 0">
<xsl:apply-templates select="./Join"/>
<xsl:apply-templates select="./Apply"/>
<xsl:apply-templates select="./CrossJoin"/>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="print-children-list"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Join">
(<xsl:apply-templates select="./*[2]"/> <xsl:call-template name="JoinType"/> <xsl:apply-templates select="./*[3]"/> ON <xsl:apply-templates select="./On/*"/>)
</xsl:template>

<xsl:template name="JoinType">
<xsl:variable name="value-node">
<xsl:value-of select="normalize-space(./JoinType/text())"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$value-node = 'LeftOuterJoin'">LEFT OUTER JOIN</xsl:when>
<xsl:when test="$value-node = 'RightOuterJoin'">RIGHT OUTER JOIN</xsl:when>
<xsl:when test="$value-node = 'FullOuterJoin'">FULL OUTER JOIN</xsl:when>
<xsl:when test="$value-node = 'InnerJoin'">INNER JOIN</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="CrossJoin">
<xsl:apply-templates select="./*[1]"/> Cross Join <xsl:apply-templates select="./*[2]"/>
</xsl:template>

<xsl:template match="Apply">
(
<xsl:apply-templates select="./*[2]"/>
<xsl:call-template name="ApplyType"/>
<xsl:apply-templates select="./*[3]"/>
)
</xsl:template>

<xsl:template name="ApplyType">
<xsl:variable name="value-node">
<xsl:value-of select="normalize-space(./ApplyType/text())"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$value-node = 'CrossApply'">        cross apply        </xsl:when>
<xsl:when test="$value-node = 'OuterApply'">        outer apply        </xsl:when>
</xsl:choose>
</xsl:template>


<xsl:template match="ColumnDefinitions">
<xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="GroupBy">
GROUP BY <xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="OrderBy">
ORDER BY <xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="Where">
WHERE <xsl:apply-templates select="./*"/>
</xsl:template>

<xsl:template match="Exists">
EXISTS (<xsl:apply-templates select="./*"/>)
</xsl:template>

<xsl:template match="Having">
HAVING <xsl:apply-templates select="./*"/>
</xsl:template>

<xsl:template match="ColumnExpressions">
<xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="ColumnUpdates">
<xsl:call-template name="print-children-list"/>
</xsl:template>

<xsl:template match="Assign">
<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/>
</xsl:template>

<xsl:template match="Insert/Target">
<xsl:apply-templates select="./Table"/>
(
<xsl:call-template name="print-list">
<xsl:with-param name="value-node" select="./ColumnUpdates/*/*[1]"/>
</xsl:call-template>
)
<xsl:if test="./*[2]/Assign">
VALUES
(
<xsl:call-template name="print-list">
<xsl:with-param name="value-node" select="./ColumnUpdates/*/*[2]"/>
</xsl:call-template>
)
</xsl:if>
</xsl:template>

<xsl:template match="Update/Target">
<xsl:apply-templates select="./Table"/>
SET <xsl:apply-templates select="./ColumnUpdates"/>
</xsl:template>

<xsl:template match="Delete/Target">
<xsl:apply-templates select="./Table"/>
</xsl:template>

<xsl:template match="Insert/Target/ColumnUpdates/Assign/SQLColumn[1]">
<!-- The table name is not printed for LHS of assignments in insert -->
<xsl:apply-templates select="./Column"/>
</xsl:template>

<xsl:template match="Create/ColumnDefinitions/SQLColumn">
<xsl:apply-templates select="./Column"/>
<xsl:if test="count(../../Phase) = 0">
<xsl:apply-templates select="./Type"/>
<xsl:apply-templates select="./Usage"/>
</xsl:if>
</xsl:template>

<xsl:template match="SQLColumn">
<xsl:variable name="table">
<xsl:if test="name(../../..) != 'Recursion' and (name(..)!='Count' or name(./Column/*[1]) != 'Asterisk')"><xsl:apply-templates select="./Table"/></xsl:if>
</xsl:variable>
<xsl:variable name="column">
<xsl:apply-templates select="./Column"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$table = ''">
<xsl:value-of select="$column"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat($table,'.', $column)"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="Create/Database|Drop/Database">
DATABASE <xsl:apply-templates select="./Name"/>
</xsl:template>

<xsl:template match="Table">
<xsl:call-template name="build-quoted-schema-object"/>
</xsl:template>

<xsl:template match="Recursion/Name">
<xsl:call-template name="quote-identifier"/>
</xsl:template>

<xsl:template match="Create/Table|Drop/Table">
TABLE <xsl:call-template name="build-quoted-schema-object"/>
</xsl:template>

<xsl:template match="View">
<xsl:call-template name="build-quoted-schema-object"/>
</xsl:template>

<xsl:template match="Drop/View">
VIEW <xsl:call-template name="build-quoted-schema-object"/>
</xsl:template>

<xsl:template match="Index">
<xsl:apply-templates select="./Name"/>
</xsl:template>

<xsl:template match="Drop/Index">
INDEX <xsl:apply-templates select="./Name"/>
</xsl:template>

<xsl:template match="Column">
<xsl:apply-templates select="./Asterisk"/>
<xsl:apply-templates select="./Name"/>
<xsl:apply-templates select="./Null"/>
</xsl:template>

<!-- Null                                                         -->
<xsl:template match="Null">NULL</xsl:template>

<xsl:template match="Table/Name|View/Name|Index/Name|Column/Name|Database/Name|Schema">
<xsl:call-template name="quote-identifier"/>
</xsl:template>

<xsl:template match="Usage">
<xsl:variable name="usage"><xsl:value-of select="."/></xsl:variable>
<xsl:choose>
<xsl:when test="$usage = 'Key'">    primary key   </xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="OpaqueExpression">
<xsl:if test="name(..) = 'As' and name(../..) = 'Sources'">
(
</xsl:if>
<xsl:value-of select="."/>
<xsl:if test="name(..) = 'As' and name(../..) = 'Sources'">
)
</xsl:if>
</xsl:template>

<xsl:template match="OpOrderExpression">
<xsl:choose>
<xsl:when test="@Op1Type = 'SqlBool'">
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="'SqlBool'"/>
<xsl:with-param name="target-type" select="'SqlBit'"/>
<xsl:with-param name="value-node" select="./*[1]"/>
</xsl:call-template>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:when>
<xsl:when test="@Op1Nullable = 'false' or @Op1Type = 'String'">
<xsl:apply-templates select="./*[1]"/>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime'">
COALESCE(<xsl:apply-templates select="./*[1]"/>, <xsl:call-template name="print-datetime-origin-value"><xsl:with-param name="db-type" select="@Op1SourceType"/></xsl:call-template>)
</xsl:when>
<xsl:otherwise>
COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)
</xsl:otherwise>
</xsl:choose>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
, (CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN 0 ELSE 1 END)
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="OrderExpression">
<xsl:apply-templates select="./*[1]"/>
<xsl:apply-templates select="./Asc"/>
<xsl:apply-templates select="./Desc"/>
</xsl:template>

<xsl:template match="Asc">ASC</xsl:template>
<xsl:template match="Desc">DESC</xsl:template>

<!-- Print values: ? for parametric queries and convert expressions
for non-parametric queries                                       -->
<xsl:template match="Parameter">
<xsl:choose>
<xsl:when test="(/Statement[not(@DQInlineParams)]) and $UseParams = 'yes' or $UseParams = 'nosubsel'">
<xsl:choose>
<xsl:when test="./@ParamName">
@<xsl:value-of select="./@ParamName"/>
</xsl:when>
<xsl:otherwise>
?
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="print-non-parametric-parameter-ref">
<xsl:with-param name="parameter-reference" select="."/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="InlineParameter">
<xsl:call-template name="print-non-parametric-parameter">
<xsl:with-param name="parameter" select="./Parameter"/>
</xsl:call-template>
</xsl:template>

<!-- Asterisk                                                         -->
<xsl:template match="Asterisk">*</xsl:template>

<!-- Count/Min/Max/Sum                                                -->
<xsl:template match="Min|Max|Sum">
<xsl:variable name="function">
<xsl:choose>
<xsl:when test="name()='Min'">MIN</xsl:when>
<xsl:when test="name()='Max'">MAX</xsl:when>
<xsl:when test="name()='Sum'">SUM</xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="$function"/>(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="Count">
COUNT(<xsl:apply-templates select="./*[1]"/> <xsl:apply-templates select="./*[2]"/>)
</xsl:template>

<!-- /Stdev/Stdevp/Var/Varp/Avg                                         -->
<xsl:template match="Stdev|Stdevp|Var|Varp|Avg">
<xsl:variable name="function">
<xsl:choose>
<xsl:when test="name()='Stdev'">STDEV</xsl:when>
<xsl:when test="name()='Stdevp'">STDEVP</xsl:when>
<xsl:when test="name()='Var'">VAR</xsl:when>
<xsl:when test="name()='Varp'">VARP</xsl:when>
<xsl:when test="name()='Avg'">AVG</xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="$function"/>(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<!-- TableToScalar -->
<xsl:template match="OpTableToScalar">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
((SELECT MIN(<xsl:apply-templates select="./*[1]"/>)) UNION (SELECT MAX(<xsl:apply-templates select="./*[1]"/>)))
</xsl:when>
<xsl:otherwise>
(CASE WHEN COUNT(*) = COUNT(<xsl:apply-templates select="./*[1]"/>) THEN ((SELECT MIN(<xsl:apply-templates select="./*[1]"/>)) UNION (SELECT MAX(<xsl:apply-templates select="./*[1]"/>))) ELSE ((SELECT MIN(<xsl:apply-templates select="./*[1]"/>)) UNION (SELECT NULL)) END)
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- CountBlank -->
<xsl:template match="OpCountBlank">
SUM(CASE WHEN (<xsl:apply-templates select="./*[1]"/>) IS NULL THEN 1 END)
</xsl:template>

<!-- CountSubqueryRows -->
<!-- Note that this operator, unlike OpCount and OpCountBlank, does not return NULL when count is 0. -->
<!-- Currently this operator is used internally and its result is assumed to be not NULL. -->
<!-- SAP hana doesn't support count_big -->
<xsl:template match="OpCountSubqueryRows">
SUM(1) OVER ()
</xsl:template>


<!-- Binary expressions                                               -->
<!-- Equal/NotEqual/Greater/GreaterOrEqual/Less/LessOrEqual/In/And/Or/Plus/Minus/Divide/Multiply
expressions                                                      -->
<xsl:template match="Equal|NotEqual|Greater|GreaterOrEqual|Less|LessOrEqual|In|And|Or|Plus|Minus|Divide|Multiply">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='Equal'">			=		</xsl:when>
<xsl:when test="name()='NotEqual'">			&lt;&gt;	</xsl:when>
<xsl:when test="name()='Greater'">			&gt;		</xsl:when>
<xsl:when test="name()='GreaterOrEqual'"><![CDATA[	>=		]]></xsl:when>
<xsl:when test="name()='Less'">				&lt;	</xsl:when>
<xsl:when test="name()='LessOrEqual'">		&lt;=	</xsl:when>
<xsl:when test="name()='In'">				IN		</xsl:when>
<xsl:when test="name()='And'">				AND		</xsl:when>
<xsl:when test="name()='Or'">				OR		</xsl:when>
<xsl:when test="name()='Plus'">				+		</xsl:when>
<xsl:when test="name()='Minus'">			-		</xsl:when>
<xsl:when test="name()='Divide'">			/		</xsl:when>
<xsl:when test="name()='Multiply'">			*		</xsl:when>
</xsl:choose>
</xsl:variable>
(
<xsl:call-template name="print-children-list">
<xsl:with-param name="operator" select="$operator"/>
</xsl:call-template>
)
</xsl:template>

<!-- Unary string functions	-->

<xsl:template match="OpLower">
LOWER(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="OpUpper">
UPPER(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="OpLen">
LEN(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="OpTrimLeft">
LTRIM(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="OpTrimRight">
RTRIM(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="OpTrim">
RTRIM(LTRIM(<xsl:apply-templates select="./*[1]"/>))
</xsl:template>

<!--
Unary expressions where NULL considered as BLANK value(more like 0).
-->

<!-- Not																													 -->
<xsl:template match="Not">
NOT(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<xsl:template match="OpNot">
NOT(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<!-- OpNot_Deprecated and BitNot																										-->
<!-- Do not use SQL NOT because we need to handle UNKNOWN in a special way -->
<xsl:template match="OpNot_Deprecated">
(CASE WHEN (<xsl:apply-templates select="./*[1]"/>) THEN 0 ELSE 1 END)
</xsl:template>

<xsl:template match="BitNot">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
(1 - (<xsl:apply-templates select="./*[1]"/>))
</xsl:when>
<xsl:otherwise>
COALESCE((1 - (<xsl:apply-templates select="./*[1]"/>)), 1)
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- UnaryMinus																													 -->
<xsl:template match="UnaryMinus">
-(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<!-- Unary Excel math functions that NULL is a fixed point. -->
<xsl:template match="OpAbs|OpCeiling|OpFloor|OpSign|OpSqrt">
<xsl:variable name="OpName">
<xsl:choose>
<xsl:when test="name()='OpAbs'">ABS</xsl:when>
<xsl:when test="name()='OpCeiling'">CEILING</xsl:when>
<xsl:when test="name()='OpFloor'">FLOOR</xsl:when>
<xsl:when test="name()='OpSign'">SIGN</xsl:when>
<xsl:when test="name()='OpSqrt'">SQRT</xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="$OpName"/>(<xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<!-- Unary Excel math functions that NULL is a fixed point. -->
<xsl:template match="OpSqr">
POWER(<xsl:apply-templates select="./*[1]"/>,2)
</xsl:template>

<!-- Unary Excel math functions that NULL is NOT a fixed point. -->
<xsl:template match="OpExp|OpLn|OpLg">
<xsl:variable name="OpName">
<xsl:choose>
<xsl:when test="name()='OpExp'">EXP</xsl:when>
<xsl:when test="name()='OpLn'">LOG</xsl:when>
<xsl:when test="name()='OpLg'">LOG10</xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
<xsl:value-of select="$OpName"/>(<xsl:apply-templates select="./*[1]"/>)
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$OpName"/>(COALESCE((<xsl:apply-templates select="./*[1]"/>), 0))
</xsl:otherwise>
</xsl:choose>
</xsl:template>


<!-- Count Rows                                                                 -->
<xsl:template match="OpCount">COUNT(<xsl:apply-templates select="./*[1]"/> <xsl:apply-templates select="./*[2]"/>)</xsl:template>

<!-- FUTURE: Avoid the redundant COUNT_BIG(DISTINCT ), either by using a subquery, or doing a projection on the results -->
<xsl:template match="OpDistinctCount">
(COUNT(DISTINCT <xsl:apply-templates select="./*[1]"/>) + MAX(CASE WHEN <xsl:apply-templates select="./*[1]"/> IS NULL THEN 1 ELSE 0 END))
</xsl:template>

<!-- FUTURE: Avoid the redundant COUNT_BIG(DISTINCT ), either by using a subquery, or doing a projection on the results -->
<xsl:template match="OpDistinctCountSkipBlank">
COUNT(DISTINCT <xsl:apply-templates select="./*[1]"/>)
</xsl:template>

<!--
Binary expressions where NULL considered as BLANK value(more like 0).
FUTURE: alleonov: maybe replace prefix Op with something else
-->
<!--Comparisons-->
<xsl:template match="OpGreater|OpLess|OpNotEqual|OpEqual|OpGreaterOrEqual|OpLessOrEqual">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='OpGreater'"> &gt; </xsl:when>
<xsl:when test="name()='OpLess'"> &lt; </xsl:when>
<xsl:when test="name()='OpNotEqual'"> &lt;&gt; </xsl:when>
<xsl:when test="name()='OpEqual'"> = </xsl:when>
<xsl:when test="name()='OpGreaterOrEqual'"> &gt;= </xsl:when>
<xsl:when test="name()='OpLessOrEqual'"> &lt;= </xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:when test="@Op1Type = 'String'">COALESCE(<xsl:apply-templates select="./*[1]"/>, '')</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">COALESCE(<xsl:apply-templates select="./*[1]"/>, <xsl:call-template name="print-datetime-origin-value"/>)</xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:when test="@Op2Type = 'String'">COALESCE(<xsl:apply-templates select="./*[2]"/>, '')</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">COALESCE(<xsl:apply-templates select="./*[2]"/>, <xsl:call-template name="print-datetime-origin-value"/>)</xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
(<xsl:value-of select="$Op1"/> <xsl:value-of select="$operator"/> <xsl:value-of select="$Op2"/>)
</xsl:template>

<!-- OpIs-->
<xsl:template match="OpIs">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' or @Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/>)
</xsl:when>
<xsl:when test="@OpsAreColRefs = 'true'">
<!--It's illegal to repeat query parameters more than once, so we can use only column references here.-->
(<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/> OR <xsl:apply-templates select="./*[1]"/> IS NULL AND <xsl:apply-templates select="./*[2]"/> IS NULL)
</xsl:when>
<xsl:otherwise>
<!--It's illegal to repeat query parameters more than once, so we can use only column references here.-->
((SELECT CASE WHEN Op1 = Op2 OR Op1 IS NULL AND Op2 IS NULL THEN 1 ELSE 0 END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictGreater-->
<xsl:template match="OpStrictGreater">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &gt; <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((SELECT (CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &gt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((SELECT (CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &gt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:when>
<xsl:otherwise>((SELECT (CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &gt; Op2 THEN 1 ELSE 0 END END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictLess-->
<xsl:template match="OpStrictLess">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &lt; <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((SELECT (CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &lt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((SELECT (CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &lt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:when>
<xsl:otherwise>((SELECT (CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &lt; Op2 THEN 1 ELSE 0 END END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictLessOrEqual-->
<xsl:template match="OpStrictLessOrEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &lt;= <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((SELECT (CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &gt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((SELECT (CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &gt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:when>
<xsl:otherwise>((SELECT (CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &lt; <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &gt;= <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &gt; Op2 THEN 1 ELSE 0 END END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictGreaterOrEqual-->
<xsl:template match="OpStrictGreaterOrEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &gt;= <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((SELECT (CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &lt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((SELECT (CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &lt; Op2 THEN 1 ELSE 0 END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:when>
<xsl:otherwise>((SELECT (CASE WHEN Op2 IS NULL THEN CASE WHEN Op1 &lt; <xsl:value-of select="$Op1Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 IS NULL THEN CASE WHEN Op2 &gt;= <xsl:value-of select="$Op2Zero"/> THEN 1 ELSE 0 END ELSE CASE WHEN Op1 &lt; Op2 THEN 1 ELSE 0 END END END)  FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictNotEqual-->
<xsl:template match="OpStrictNotEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> &lt;&gt; <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((SELECT CASE WHEN Op2 IS NULL THEN 0 ELSE CASE WHEN Op1 = Op2 THEN 1 ELSE 0 END END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((SELECT CASE WHEN Op1 IS NULL THEN 0 ELSE CASE WHEN Op1 = Op2 THEN 1 ELSE 0 END END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:when>
<xsl:otherwise>((SELECT CASE WHEN Op1 = Op2 OR (Op1 IS NULL AND Op2 IS NULL) THEN 1 ELSE 0 END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 0)</xsl:otherwise>
</xsl:choose>
</xsl:template>
<!-- OpStrictEqual-->
<xsl:template match="OpStrictEqual">
<xsl:variable name="Op1Zero">
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">''</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2Zero">
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">''</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
<xsl:call-template name="print-datetime-origin-value"/>
</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">(<xsl:apply-templates select="./*[1]"/> = <xsl:apply-templates select="./*[2]"/>)</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">((SELECT CASE WHEN Op2 IS NULL THEN 0 ELSE CASE WHEN Op1 = Op2 THEN 1 ELSE 0 END END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">((SELECT CASE WHEN Op1 IS NULL THEN 0 ELSE CASE WHEN Op1 = Op2 THEN 1 ELSE 0 END END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:when>
<xsl:otherwise>((SELECT CASE WHEN Op1 = Op2 OR (Op1 IS NULL AND Op2 IS NULL) THEN 1 ELSE 0 END FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable) = 1)</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- OpAdd-->
<xsl:template match="OpAdd">
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime' and @Op2Type = 'Datetime'">
(SELECT COALESCE(ADD_SECONDS(AuxTable.Op1, SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, AuxTable.Op2)), AuxTable.Op1, AuxTable.Op2) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
(SELECT COALESCE(ADD_SECONDS(AuxTable.Op1, AuxTable.Op2), AuxTable.Op1, ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, AuxTable.Op2)) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, (<xsl:apply-templates select="./*[2]"/>) * 86400 AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
(SELECT COALESCE(ADD_SECONDS(AuxTable.Op2, AuxTable.Op1), ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, AuxTable.Op1), AuxTable.Op2) FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) * 86400 AS Op1, (<xsl:apply-templates select="./*[2]"/>) AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> + <xsl:apply-templates select="./*[2]"/>)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">
(SELECT COALESCE(AuxTable.Op1 + AuxTable.Op2, AuxTable.Op1) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">
(SELECT COALESCE((<xsl:apply-templates select="./*[1]"/>) + AuxTable.Op2, AuxTable.Op2) FROM (SELECT <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:otherwise>
(SELECT COALESCE(AuxTable.Op1 + AuxTable.Op2, AuxTable.Op1, AuxTable.Op2) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- OpSubtract																													 -->
<xsl:template match="OpSubtract">
<xsl:choose>
<xsl:when test="@Op1Type = 'Datetime' and @Op2Type = 'Datetime'">
(SELECT COALESCE(ADD_SECONDS(AuxTable.Op1, AuxTable.Op2), AuxTable.Op1, ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, AuxTable.Op2)) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, <xsl:apply-templates select="./*[2]"/>)*-1 AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op1Type = 'Datetime'">
(SELECT COALESCE(ADD_SECONDS(AuxTable.Op1, AuxTable.Op2), AuxTable.Op1, ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, AuxTable.Op2)) FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, (<xsl:apply-templates select="./*[2]"/>)*-86400 AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op2Type = 'Datetime'">
(SELECT COALESCE(ADD_SECONDS(AuxTable.Op1, AuxTable.Op2), AuxTable.Op1, ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, AuxTable.Op2)) FROM (SELECT ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, <xsl:apply-templates select="./*[1]"/>) AS Op1, SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, <xsl:apply-templates select="./*[2]"/>)*-1 AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false' and @Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> - <xsl:apply-templates select="./*[2]"/>)
</xsl:when>
<xsl:when test="@Op1Nullable = 'false'">
(SELECT COALESCE(AuxTable.Op1 - AuxTable.Op2, AuxTable.Op1) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:when test="@Op2Nullable = 'false'">
(SELECT COALESCE((<xsl:apply-templates select="./*[1]"/>) - AuxTable.Op2, -AuxTable.Op2) FROM (SELECT <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:when>
<xsl:otherwise>
(SELECT COALESCE(AuxTable.Op1 - AuxTable.Op2, AuxTable.Op1, -AuxTable.Op2) FROM (SELECT (<xsl:apply-templates select="./*[1]"/>) AS Op1, <xsl:apply-templates select="./*[2]"/> AS Op2 from dummy) as AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- OpDivide																													 -->
<xsl:template match="OpDivide">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op1Type = 'Currency' and @Op2Type != 'Currency'">
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Currency'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Double'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'">
(<xsl:apply-templates select="./*[1]"/> / <xsl:value-of select="$Op2"/>)
</xsl:when>
<xsl:otherwise>
(<xsl:apply-templates select="./*[1]"/> / COALESCE(<xsl:value-of select="$Op2"/>, 0))
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- OpMultiply																													 -->
<xsl:template match="OpMultiply">
<xsl:choose>
<xsl:when test="@Op1Type = 'Currency' and @Op2Type = 'Currency'">
(<xsl:apply-templates select="./*[1]"/> *
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="'Currency'"/>
<xsl:with-param name="target-type" select="'Double'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>)
</xsl:when>
<xsl:when test="@Op1Type = 'Double' and @Op2Type = 'Currency' or @Op2Type = 'Double' and @Op1Type = 'Currency'">
<!--FUTURE: RT: it's impossible to use <xsl:call-template name="OpCast"/> here,
so using direct cast. It gives us desired result here.					-->
TO_DECIMAL(ROUND(<xsl:apply-templates select="./*[1]"/> * <xsl:apply-templates select="./*[2]"/>, 4), 19 ,4)
</xsl:when>
<xsl:otherwise>
(<xsl:apply-templates select="./*[1]"/> * <xsl:apply-templates select="./*[2]"/>)
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- OpSafeDivide																													 -->
<xsl:template match="OpSafeDivide">
<!-- ***** This part is from OpDivide above ***** -->
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op1Type = 'Currency' and @Op2Type != 'Currency'">
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Currency'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="OpCast">
<xsl:with-param name="param-type" select="@Op2Type"/>
<xsl:with-param name="target-type" select="'Double'"/>
<xsl:with-param name="value-node" select="./*[2]"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<!-- ***** End of part from OpDivide.       ***** -->
(SELECT
CASE WHEN AuxTable.Op1 IS NULL
THEN NULL
ELSE
CASE WHEN AuxTable.Op2 IS NULL OR AuxTable.Op2 = 0
THEN AuxTable.Op3
ELSE AuxTable.Op1 / AuxTable.Op2
END
END
FROM (SELECT
<xsl:apply-templates select="./*[1]"/> AS Op1,
<xsl:value-of select="$Op2"/> AS Op2,
<xsl:apply-templates select="./*[3]"/> AS Op3 FROM dummy
) AS AuxTable
)
</xsl:template>

<xsl:template match="OpInList">
(<xsl:call-template name="print-children-list"></xsl:call-template>)
</xsl:template>

<xsl:template match="OpIn|OpNaryOr">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='OpIn'"			> IN </xsl:when>
<xsl:when test="name()='OpNaryOr'"		> OR </xsl:when>
</xsl:choose>
</xsl:variable>
(
<xsl:call-template name="print-children-list">
<xsl:with-param name="operator" select="$operator"/>
</xsl:call-template>
)
</xsl:template>


<!-- OpOr|OpAnd																													 -->
<xsl:template match="OpOr|OpAnd">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='OpOr'">OR</xsl:when>
<xsl:when test="name()='OpAnd'">AND</xsl:when>
</xsl:choose>
</xsl:variable>
(<xsl:apply-templates select="./*[1]"/> <xsl:value-of select="$operator"/> <xsl:apply-templates select="./*[2]"/>)
</xsl:template>



<!-- Coalesce                                               -->
<xsl:template match="Coalesce">COALESCE(<xsl:call-template name="print-children-list"/>)</xsl:template>

<!-- Postfix unary expressions                                        -->
<!-- IsNull
expressions                                                      -->
<xsl:template match="IsNull">
<xsl:variable name="operator">
<xsl:choose>
<xsl:when test="name()='IsNull'"> IS NULL </xsl:when>
</xsl:choose>
</xsl:variable>
(
<xsl:apply-templates select="./*[1]"/>
<xsl:value-of select="$operator"/>
)
</xsl:template>

<!-- Types                                                            -->
<xsl:template match="Type">
<xsl:variable name="type-val"><xsl:value-of select="normalize-space(./text())"/></xsl:variable>
<xsl:choose>
<xsl:when test="$type-val = 'DBTYPE_BSTR'">    nvarchar     </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_WSTR'">    nvarchar     </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_STR'">     varchar      </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_BOOL'">    int          </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I1'">      tinyint      </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I2'">      smallint     </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I4'">      int          </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_I8'">      bigint       </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI1'">     tinyint      </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI2'">     smallint     </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI4'">     int          </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_UI8'">     bigint       </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_R4'">      float        </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_R8'">      double       </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_DATE'">    timestamp    </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_DBTIMESTAMP'">    timestamp     </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_CY'">      decimal(19,4)       </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_VARIANT'"> sql_variant  </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_GUID'"> uniqueidentifier  </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_ByteArray'"> varbinary  </xsl:when>
<xsl:when test="$type-val = 'DBTYPE_DECIMAL'"> decimal      </xsl:when>
</xsl:choose>
<xsl:apply-templates select="./Size"/>
<xsl:apply-templates select="./Precision"/>
<xsl:apply-templates select="./Scale"/>
</xsl:template>

<!-- True and False                                                       -->
<xsl:template match="True">
<xsl:choose>
<xsl:when test="@SqlBool = 'true'">1 = 1</xsl:when>
<xsl:otherwise>1</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="False">
<xsl:choose>
<xsl:when test="@SqlBool = 'true'">1 = 0</xsl:when>
<xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:template>


<!-- Size (optional)                                                  -->
<xsl:template match="Size">
( <xsl:value-of select="./text()"/> )
</xsl:template>

<!-- Precision (optional)                                                  -->
<xsl:template match="Precision">
( <xsl:value-of select="./text()"/>
</xsl:template>

<!-- Scale (optional)                                                  -->
<xsl:template match="Scale">
, <xsl:value-of select="./text()"/> )
</xsl:template>
<!-- Cast                                                             -->
<xsl:template match="Cast">
CAST(<xsl:apply-templates select="./*[1]"/> AS <xsl:apply-templates select="./*[2]"/>)
</xsl:template>

<!-- OpCast                                                             -->
<!-- Known types:                                                       -->
<!--     Double                                                         -->
<!--     Integer                                                        -->
<!--     Currency                                                       -->
<!--     SqlBool                                                        -->
<!--     Timestamp                                                      -->
<!--     String                                                         -->
<xsl:template name="OpCast" match="OpCast">
<xsl:param name="param-type" select="@Op1Type"/>
<xsl:param name="target-type" select="@ResultType"/>
<xsl:param name="unicode" select="@Unicode"/>
<xsl:param name="source-target-type" select="@SourceTargetType"/>
<xsl:param name="value-node" select="./*[1]"/>
<xsl:choose>

<xsl:when test="$target-type = 'Double'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
(SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, <xsl:apply-templates select="$value-node"/>)/86400)
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1.0 ELSE 0.0 END)
</xsl:when>
<xsl:when test="$param-type = 'SqlBit'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> = 1 THEN 1.0 ELSE 0.0 END)
</xsl:when>
<xsl:otherwise>TO_DOUBLE(<xsl:apply-templates select="$value-node"/>)</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'Integer'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
TO_BIGINT(ROUND(SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, <xsl:apply-templates select="$value-node"/>)/86400, 0))
</xsl:when>
<xsl:when test="$param-type = 'Double' or $param-type = 'Currency'">
TO_BIGINT(ROUND((<xsl:apply-templates select="$value-node"/>), 0))
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END)
</xsl:when>
<xsl:otherwise>
TO_BIGINT(<xsl:apply-templates select="$value-node"/>)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="$target-type = 'Currency'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
TO_DECIMAL(ROUND(SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, <xsl:apply-templates select="$value-node"/>) / 86400, 4), 19, 4)
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
TO_DECIMAL(ROUND((CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END), 4), 19, 4)
</xsl:when>
<xsl:when test="$param-type = 'Currency'">
<xsl:apply-templates select="$value-node"/>
</xsl:when>
<xsl:otherwise>
TO_DECIMAL(ROUND(<xsl:apply-templates select="$value-node"/>, 4), 19, 4)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="$target-type = 'SqlBool'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
(<xsl:apply-templates select="$value-node"/> &lt;&gt; <xsl:call-template name="print-datetime-origin-value"/>)
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
<xsl:apply-templates select="$value-node"/>
</xsl:when>
<xsl:when test="$param-type = 'String'">
(TO_BIGINT(<xsl:apply-templates select="$value-node"/>) &lt;&gt; 0)
</xsl:when>
<xsl:otherwise>
(<xsl:apply-templates select="$value-node"/> &lt;&gt; 0)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="$target-type = 'SqlBit'">
<xsl:choose>
<xsl:when test="$param-type = 'Datetime'">
(CASE WHEN SECONDS_BETWEEN(<xsl:call-template name="print-datetime-origin-value"/>, (<xsl:apply-templates select="$value-node"/>)) = 0 THEN 0 ELSE 1 END)
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 1 ELSE 0 END)
</xsl:when>
<xsl:when test="$param-type = 'String'">
(CASE WHEN TO_INT(<xsl:apply-templates select="$value-node"/>) &lt;&gt; 0 THEN 1 ELSE 0 END)
</xsl:when>
<xsl:otherwise>
(CASE WHEN <xsl:apply-templates select="$value-node"/> &lt;&gt; 0 THEN 1 ELSE 0 END)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="$target-type = 'Datetime'">
<xsl:choose>
<xsl:when test="$param-type = 'SqlBool'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN timestamp'1899-12-31 00:00:00' ELSE <xsl:call-template name="print-datetime-origin-value"/> END)
</xsl:when>
<xsl:when test="$param-type = 'Double'
or $param-type = 'SqlBit'
or $param-type = 'Integer'
or $param-type = 'Currency'">
ADD_SECONDS(<xsl:call-template name="print-datetime-origin-value"/>, (<xsl:apply-templates select="$value-node"/>) * 86400)
</xsl:when>
<xsl:when test="$param-type = 'Datetime'">
<xsl:apply-templates select="$value-node"/>
</xsl:when>
<xsl:otherwise>
TO_TIMESTAMP(<xsl:apply-templates select="$value-node"/>)
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$target-type = 'String'">
<xsl:choose>
<xsl:when test="$param-type = 'SqlBit'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> = 1 THEN 'TRUE' ELSE 'FALSE' END)
</xsl:when>
<xsl:when test="$param-type = 'SqlBool'">
(CASE WHEN <xsl:apply-templates select="$value-node"/> THEN 'TRUE' ELSE 'FALSE' END)
</xsl:when>
<xsl:when test="$param-type = 'String'">
<xsl:apply-templates select="$value-node"/>
</xsl:when>
<xsl:when test="$unicode = 'true'">
CAST(<xsl:apply-templates select="$value-node"/> AS NVARCHAR(4000))
</xsl:when>
<xsl:otherwise>
CAST(<xsl:apply-templates select="$value-node"/> AS VARCHAR(4000))
</xsl:otherwise>
</xsl:choose>
</xsl:when>

<xsl:when test="$source-target-type != ''">
CAST(<xsl:apply-templates select="$value-node"/> AS <xsl:apply-templates select="$source-target-type"/>)
</xsl:when>

<xsl:otherwise>
<xsl:message terminate="yes">Hana cartridge error: OpCast: ResultType is not specified</xsl:message>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- OpCase -->
<xsl:template match="OpCase">
(
CASE
<xsl:for-each select="IfClause">
WHEN <xsl:apply-templates select="./Condition/*[1]"/>
THEN <xsl:apply-templates select="./Then/*[1]"/>
</xsl:for-each>
ELSE <xsl:apply-templates select="./Else/*[1]"/>
END
)
</xsl:template>

<!-- OpRank|OpDenseRank|RowNumber|Ntile -->
<xsl:template match="OpRank|OpDenseRank|OpRowNumber|OpNtile">
<xsl:variable name="rank_function">
<xsl:choose>
<xsl:when test="name()='OpRank'"> RANK() </xsl:when>
<xsl:when test="name()='OpDenseRank'"> DENSE_RANK() </xsl:when>
<xsl:when test="name()='OpRowNumber'"> ROW_NUMBER() </xsl:when>
<xsl:when test="name()='OpNtile'"> NTILE(<xsl:apply-templates select="./*[1]"/>) </xsl:when>
</xsl:choose>
</xsl:variable>
<xsl:value-of select="$rank_function"/>
OVER
(
<xsl:apply-templates select="./PartitionBy"/>
<xsl:apply-templates select="./OrderBy"/>
)
</xsl:template>

<xsl:template match="PartitionBy">
PARTITION BY <xsl:call-template name="print-children-list"/>
</xsl:template>

<!-- Literal -->
<xsl:template match="Literal">
<xsl:value-of select="."/>
</xsl:template>

<!-- By default don't do anything                                     -->
<xsl:template match="*">
</xsl:template>

<!-- Print a schema object                                               -->
<xsl:template name="build-quoted-schema-object">
<xsl:param name="schema-object-node" select="."/>

<xsl:variable name="unquoted-schema">
<xsl:value-of select="$schema-object-node/Schema"/>
</xsl:variable>
<xsl:variable name="schema">
<xsl:apply-templates select="$schema-object-node/Schema"/>
</xsl:variable>
<xsl:variable name="table">
<xsl:apply-templates select="$schema-object-node/Name"/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$unquoted-schema = ''">
<xsl:value-of select="$table"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat($schema,'.', $table)"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- Convert an identifier to the OLEDB quotation form                -->
<xsl:template name="quote-identifier">
<xsl:param name="identifier" select="."/>

<xsl:value-of select="$IdentifierStartQuotingCharacter"/>
<xsl:call-template name="normalize-entity-aux">
<xsl:with-param name="entity" select="$identifier"/>
<xsl:with-param name="end-quoting-char" select="$IdentifierEndQuotingCharacter"/>
</xsl:call-template>
<xsl:value-of select="$IdentifierEndQuotingCharacter"/>
</xsl:template>

<!-- Convert a string to the string quotation form                    -->
<xsl:template name="quote-string">
<xsl:param name="string" select="."/>
<xsl:param name="unicode" select="."/>
<xsl:choose>
<xsl:when test="$unicode != 'false'"><xsl:value-of select="$UnicodeStringPrefix"/></xsl:when>
</xsl:choose>
<xsl:value-of select="$StringQuotingCharacter"/>
<xsl:call-template name="normalize-entity-aux">
<xsl:with-param name="entity" select="$string"/>
<xsl:with-param name="end-quoting-char" select="$StringQuotingCharacter"/>
</xsl:call-template>
<xsl:value-of select="$StringQuotingCharacter"/>
</xsl:template>

<!-- Convert an entity to the quotation form (recursive, aux)  by
duplicating the end quoting character                            -->
<xsl:template name="normalize-entity-aux">
<xsl:param name="entity"/>
<xsl:param name="end-quoting-char"/>

<xsl:choose>
<xsl:when test="contains($entity, $end-quoting-char)">
<xsl:value-of select="substring-before($entity, $end-quoting-char)"/>
<xsl:value-of select="$end-quoting-char"/>
<xsl:value-of select="$end-quoting-char"/>
<xsl:call-template name="normalize-entity-aux">
<xsl:with-param name="entity" select="substring-after($entity, $end-quoting-char)"/>
<xsl:with-param name="end-quoting-char" select="$end-quoting-char"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$entity"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- Print the children list                                          -->
<xsl:template name="print-children-list">
<xsl:param name="value-node" select="."/>
<xsl:param name="operator" select="','"/>
<xsl:param name="prefix" select="''"/>

<xsl:call-template name="print-list">
<xsl:with-param name="value-node" select="$value-node/*"/>
<xsl:with-param name="operator" select="$operator"/>
<xsl:with-param name="prefix" select="$prefix"/>
</xsl:call-template>
</xsl:template>

<!-- Print a list                                                     -->
<xsl:template name="print-list">
<xsl:param name="operator" select="','"/>
<xsl:param name="value-node" select="."/>
<xsl:param name="prefix" select="''"/>

<xsl:for-each select="$value-node">
<xsl:call-template name="print-element-optional-prefix">
<xsl:with-param name="value-node" select="."/>
<xsl:with-param name="prefix" select="$prefix"/>
</xsl:call-template>
<xsl:if test="position()!=last()">
<xsl:value-of select="$operator"/>
</xsl:if>
</xsl:for-each>
</xsl:template>

<!-- Print a list of pairs connected by =                             -->
<xsl:template name="print-children-pair-list">
<xsl:param name="value-node1" select="."/>
<xsl:param name="value-node2" select="."/>
<xsl:param name="prefix1" select="''"/>
<xsl:param name="prefix2" select="''"/>
<xsl:param name="operator" select="' AND '"/>
<xsl:param name="connector" select="' = '"/>

<xsl:for-each select="$value-node1/*">
<xsl:call-template name="print-element-optional-prefix">
<xsl:with-param name="value-node" select="."/>
<xsl:with-param name="prefix" select="$prefix1"/>
</xsl:call-template>
<xsl:value-of select="$connector"/>
<xsl:call-template name="print-element-optional-prefix">
<xsl:with-param name="value-node" select="$value-node2/*[position()]"/>
<xsl:with-param name="prefix" select="$prefix2"/>
</xsl:call-template>
<xsl:if test="position()!=last()">
<xsl:value-of select="$operator"/>
</xsl:if>
</xsl:for-each>
</xsl:template>

<!-- Print an element giving it an optional prefix                    -->
<xsl:template name="print-element-optional-prefix">
<xsl:param name="value-node" select="."/>
<xsl:param name="prefix" select="''"/>

<xsl:for-each select="$value-node">
<xsl:variable name="element">
<xsl:apply-templates select="."/>
</xsl:variable>
<xsl:choose>
<xsl:when test="$prefix = ''">
<xsl:value-of select="$element"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat($prefix, '.', $element)"/>
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:template>

<!-- Get the value of a parameter ref for the query                   -->
<xsl:template name="print-non-parametric-parameter-ref">
<xsl:param name="parameter-reference"/>

<xsl:variable name="reference"><xsl:value-of select="$parameter-reference/@ref"/></xsl:variable>
<xsl:call-template name="print-non-parametric-parameter">
<xsl:with-param name="parameter" select="/Statement/Parameters/Parameter[@id=$reference]"/>
</xsl:call-template>
</xsl:template>

<!-- Get the value of a parameter ref for the query                   -->
<xsl:template name="print-non-parametric-parameter">
<xsl:param name="parameter"/>

<xsl:variable name="db-type"><xsl:value-of select="$parameter/@DBTYPE"/></xsl:variable>
<xsl:variable name="value"><xsl:value-of select="$parameter/text()"/></xsl:variable>
<xsl:choose>
<xsl:when test="$db-type = 'DBTYPE_BSTR'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_WSTR'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_STR'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/><xsl:with-param name="unicode" select="false"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_BOOL'">CAST(<xsl:value-of select="$value"/> AS int)</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I1'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I2'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I4'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_I8'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI1'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI2'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI4'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_UI8'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_R4'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_R8'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DATE'">timestamp<xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/><xsl:with-param name="unicode" select="false"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBDATE'">date<xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/><xsl:with-param name="unicode" select="false"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBTIME'">time<xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/><xsl:with-param name="unicode" select="false"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBTIMESTAMP'">timestamp<xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/><xsl:with-param name="unicode" select="false"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_CY'">CAST( <xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template> AS double)</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_VARIANT'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_GUID'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_ByteArray'"><xsl:call-template name="quote-string"><xsl:with-param name="string" select="$value"/></xsl:call-template></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DECIMAL'"><xsl:value-of select="$value"/></xsl:when>
<xsl:when test="$db-type = 'DBTYPE_EMPTY'">NULL</xsl:when>
</xsl:choose>
</xsl:template>

<!-- Set datetime default value                   -->
<xsl:template name="print-datetime-origin-value">
<xsl:param name="db-type"/>
<xsl:choose>
<xsl:when test="$db-type = 'DBTYPE_DBTIME'">time'00:00:00'</xsl:when>
<xsl:when test="$db-type = 'DBTYPE_DBDATE'">date'1899-12-30'</xsl:when>
<xsl:otherwise>timestamp'1899-12-30 00:00:00'</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template match="OpRAND">RAND()</xsl:template>

<xsl:template match="OpABS">ABS(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpASIN">ASIN(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpATAN">ATAN(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpSIGN">SIGN(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpSIN">SIN(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpSINH">SINH(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpSQRT">SQRT(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpTAN">TAN(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpTANH">TANH(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<xsl:template match="OpACOS|OpACOT|OpCOS|OpCOSH|OpCOT|OpEXP|OpLN|OpLOG10">
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="name()='OpACOS'">ACOS(<xsl:value-of select="$Op1"/>)</xsl:when>
<xsl:when test="name()='OpACOT'">(1.5707963267949 - ATAN(<xsl:value-of select="$Op1"/>))</xsl:when>
<xsl:when test="name()='OpCOS'">COS(<xsl:value-of select="$Op1"/>)</xsl:when>
<xsl:when test="name()='OpCOSH'">COSH(<xsl:value-of select="$Op1"/>)</xsl:when>
<xsl:when test="name()='OpCOT'">COT(<xsl:value-of select="$Op1"/>)</xsl:when>
<xsl:when test="name()='OpEXP'">EXP(<xsl:value-of select="$Op1"/>)</xsl:when>
<xsl:when test="name()='OpLN'">LN(<xsl:value-of select="$Op1"/>)</xsl:when>
<xsl:when test="name()='OpLOG10'">LOG(10, <xsl:value-of select="$Op1"/>)</xsl:when>
</xsl:choose>
</xsl:template>

<!-- MAX/MIN differ from DAX by converting BLANK to 0 or '' to keep SQL expressions simple -->
<xsl:template match="OpMAX|OpMIN">
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="@Op1Type = 'String'">COALESCE(<xsl:apply-templates select="./*[1]"/>, '')</xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>
<xsl:choose>
<xsl:when test="@Op2Type = 'String'">COALESCE(<xsl:apply-templates select="./*[2]"/>, '')</xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="name()='OpMAX'">GREATEST(<xsl:value-of select="$Op1"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
<xsl:when test="name()='OpMIN'">LEAST(<xsl:value-of select="$Op1"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
</xsl:choose>
</xsl:template>

<!-- LOG differ from DAX by converting BLANK to 0 to keep SQL expressions simple -->
<xsl:template match="OpLOG">
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
LOG(<xsl:value-of select="$Op2"/>, <xsl:value-of select="$Op1"/>)
</xsl:template>

<xsl:template match="OpMOD|OpPOWER|OpQUOTIENT|OpROUND|OpTRUNC|OpROUNDDOWN|OpROUNDUP|OpMROUND|OpCEILING|OpISO.CEILING">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<!-- SAP Hana MOD function behaves differently from DAX MOD function -->
<!-- To generate simplier query, MOD deliberately returns NULL instead of error when Op1 is NULL even though Op2 is 0 or NULL -->
<xsl:when test="name()='OpMOD'">(SELECT Op1 - Op2 * ROUND(Op1 / Op2, 0, ROUND_FLOOR) FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:value-of select="$Op2"/> AS Op2 FROM DUMMY))</xsl:when>
<!-- SAP Hana POWER(0, 0) = 1. This is different from DAX but we use POWER directly for simpler query generation. -->
<xsl:when test="name()='OpPOWER'">POWER(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
<xsl:when test="name()='OpQUOTIENT'">TO_DOUBLE(TO_BIGINT(<xsl:apply-templates select="./*[1]"/> / <xsl:value-of select="$Op2"/>))</xsl:when>
<xsl:when test="name()='OpROUND'">ROUND(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
<xsl:when test="name()='OpTRUNC'">ROUND(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>, ROUND_DOWN)</xsl:when>
<xsl:when test="name()='OpROUNDDOWN'">ROUND(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>, ROUND_DOWN)</xsl:when>
<xsl:when test="name()='OpROUNDUP'">
<xsl:choose>
<xsl:when test="@Op2Static>=0">
ROUND(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>, ROUND_UP)
</xsl:when>
<xsl:otherwise>
(SELECT CEIL(ABS(Op1) * Op2) * SIGN(Op1) / Op2 FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, POWER(10.0, <xsl:value-of select="$Op2"/>) AS Op2 FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="name()='OpMROUND'">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
(SELECT CASE WHEN Op2 = 0 THEN 0 ELSE ROUND(Op1/Op2, 0)*Op2 END FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:value-of select="$Op2"/> AS Op2 FROM DUMMY) AS AuxTable)
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN Op1 IS NULL THEN NULL ELSE CASE WHEN Op2 = 0 THEN 0 ELSE ROUND(Op1/Op2, 0)*Op2 END END FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:value-of select="$Op2"/> AS Op2 FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="name()='OpCEILING'">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
<xsl:choose>
<xsl:when test="@Op2Static=1">
CEILING(<xsl:apply-templates select="./*[1]"/>)
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN Op2 = 0 THEN 0 ELSE CEILING(Op1/Op2)*Op2 END FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:value-of select="$Op2"/> AS Op2 FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN Op1 IS NULL THEN NULL ELSE CASE WHEN Op2 = 0 THEN 0 ELSE CEILING(Op1/Op2)*Op2 END END FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, <xsl:value-of select="$Op2"/> AS Op2 FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="name()='OpISO.CEILING'">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'">
<xsl:choose>
<xsl:when test="@Op2Static=1">
CEILING(<xsl:apply-templates select="./*[1]"/>)
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN Op2 = 0 THEN 0 ELSE CEILING(Op1/Op2)*Op2 END FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, ABS(<xsl:value-of select="$Op2"/>) AS Op2 FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN Op1 IS NULL THEN NULL ELSE CASE WHEN Op2 = 0 THEN 0 ELSE CEILING(Op1/Op2)*Op2 END END FROM (SELECT <xsl:apply-templates select="./*[1]"/> AS Op1, ABS(<xsl:value-of select="$Op2"/>) AS Op2 FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="OpINT">FLOOR(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<xsl:template match="OpDEGREES">(<xsl:apply-templates select="./*[1]"/> * 57.2957795130823)</xsl:template>
<xsl:template match="OpRADIANS">(<xsl:apply-templates select="./*[1]"/> * 0.0174532925199433)</xsl:template>
<xsl:template match="OpSQRTPI">SQRT(<xsl:apply-templates select="./*[1]"/> * 3.14159265358979)</xsl:template><!-- YEAR/MONTH/DAY/EDATE/EOMONTH raise error if argument data type is TIME. -->
<!-- IMBI does not as it converts TIME to date/time during import. -->
<!-- It is acceptable to raise error in those cases as day/month/year level operations don't apply to TIME -->

<xsl:template match="OpDAY">DAYOFMONTH(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpMONTH">MONTH(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpQUARTER">CEILING(MONTH(<xsl:apply-templates select="./*[1]"/>)/3)</xsl:template>
<xsl:template match="OpYEAR">YEAR(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpHOUR">HOUR(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpMINUTE">MINUTE(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpSECOND">SECOND(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<xsl:template match="OpWEEKNUM">
<xsl:choose>
<xsl:when test="@WeekBeginsOn='Monday' and @System='2'">TO_INT(RIGHT(ISOWEEK(<xsl:apply-templates select="./*[1]"/>), 2))</xsl:when>
<xsl:otherwise>
<xsl:message terminate="yes">Cartridge error: Unsupported parameters for OpWEEKNUM.</xsl:message>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="OpWEEKDAY">
<!-- We are making assumptions here. In theory, we need to check SELECT @@DATEFIRST and generate SQL accordingly. -->
<xsl:choose>
<xsl:when test="@WeekBeginsOn='Sunday' and @FirstDayIndex='1'">(WEEKDAY(ADD_DAYS(<xsl:apply-templates select="./*[1]"/>, 1)) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Monday' and @FirstDayIndex='1'">(WEEKDAY(<xsl:apply-templates select="./*[1]"/>) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Tuesday' and @FirstDayIndex='1'">(WEEKDAY(ADD_DAYS(<xsl:apply-templates select="./*[1]"/>, -1)) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Wednesday' and @FirstDayIndex='1'">(WEEKDAY(ADD_DAYS(<xsl:apply-templates select="./*[1]"/>, -2)) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Thursday' and @FirstDayIndex='1'">(WEEKDAY(ADD_DAYS(<xsl:apply-templates select="./*[1]"/>, -3)) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Friday' and @FirstDayIndex='1'">(WEEKDAY(ADD_DAYS(<xsl:apply-templates select="./*[1]"/>, -4)) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Saturday' and @FirstDayIndex='1'">(WEEKDAY(ADD_DAYS(<xsl:apply-templates select="./*[1]"/>, -5)) + 1)</xsl:when>
<xsl:when test="@WeekBeginsOn='Monday' and @FirstDayIndex='0'">WEEKDAY(<xsl:apply-templates select="./*[1]"/>)</xsl:when>
<xsl:otherwise>
<xsl:message terminate="yes">Cartridge error: Unsupported parameters for OpWEEKDAY.</xsl:message>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="OpEDATE|OpEOMONTH">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="name()='OpEDATE'">ADD_MONTHS(TO_DATE(<xsl:apply-templates select="./*[1]"/>), <xsl:value-of select="$Op2"/>)</xsl:when>
<xsl:when test="name()='OpEOMONTH'">LAST_DAY(ADD_MONTHS(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>))</xsl:when>
</xsl:choose>
</xsl:template>
<!-- WARNING: Hana only has NVARCHAR(5000) but no NVARCHAR(MAX). For a string function, Hana tries to -->
<!--          find the minimal length of the output string. But if Hana cannot decide the minimum     -->
<!--          length, it will return NVARCHAR(5000) which OLE/DB over ODBC driver will return wrong   -->
<!--          result 100% of time. While it is not a problem for measures, it will be a serious issue -->
<!--          for calculated columns and calculated tables. We MUST inject leaf level cast in those   -->
<!--          cases or find out if there is a way to fix the OLE/DB over ODBC driver bug.             -->

<xsl:template match="OpLEN">LENGTH(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpLOWER">LOWER(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpUPPER">UPPER(<xsl:apply-templates select="./*[1]"/>)</xsl:template>
<xsl:template match="OpVALUE">TO_DOUBLE(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<!-- We cannot expect Hana to convert strings to dates in the same way as DAX -->
<!-- Hana asks user to input date format, default is YYYY-MM-DD -->
<!-- DAX DATEVALUE can handle a variety of date formats automatically -->
<xsl:template match="OpDATEVALUE">TO_DATE(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<!-- We cannot expect Hana to convert strings to time in the same way as DAX -->
<!-- Hana asks user to input date format, default is HH24:MI:SS or HH12:MI:SS AM|PM -->
<!-- DAX TIMEVALUE can handle a variety of date formats automatically -->
<xsl:template match="OpTIMEVALUE">TO_TIMESTAMP(CONCAT('1899-12-30 ', TO_TIME(<xsl:apply-templates select="./*[1]"/>)))</xsl:template>

<xsl:template match="OpUNICHAR">NCHAR(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<!-- UNICODE(<empty string>) returns 0 in Hana but BLANK in DAX -->
<xsl:template match="OpUNICODE">UNICODE(<xsl:apply-templates select="./*[1]"/>)</xsl:template>

<!-- Intentionally different from DAX TRIM function to generate simpler expression in common cases -->
<!-- SAP Hana TRIM does not remove spaces between words -->
<xsl:template match="OpTRIM">TRIM(' ' FROM <xsl:apply-templates select="./*[1]"/>)</xsl:template>

<xsl:template match="OpLEFT|OpRIGHT">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<!-- Intentionally different from DAX LEFT function to generate simpler expression in common cases -->
<!-- DAX LEFT(<string>, <negative number>) raises error but Hana returns '' -->
<xsl:when test="name()='OpLEFT'">LEFT(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
<!-- Intentionally different from DAX RIGHT function to generate simpler expression in common cases -->
<!-- DAX RIGHT(<string>, <negative number>) raises error but Hana returns '' -->
<xsl:when test="name()='OpRIGHT'">RIGHT(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="OpCONCATENATE">
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, '')</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, '')</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<!-- Intentionally different from DAX CONCATENATE function and & operator to generate simpler expression in common cases -->
<!-- BLANK() & BLANK() returns BLANK in DAX but generated code returns '' in Hana -->
<xsl:when test="name()='OpCONCATENATE'">CONCAT(<xsl:value-of select="$Op1"/>, <xsl:value-of select="$Op2"/>)</xsl:when>

<!-- SAP Hana seems to perform case sensitive comparisons by default -->
<!-- It's weird that EXACT("", BLANK()) returns TRUE in DAX -->
<!-- Maybe TO_BINARY and then compare -->
<!-- xsl:when test="name()='OpEXACT'"></xsl:when -->
</xsl:choose>
</xsl:template>

<xsl:template match="OpMID">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op3">
<xsl:choose>
<xsl:when test="@Op3Nullable = 'false'"><xsl:apply-templates select="./*[3]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[3]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<!-- Intentionally different from DAX MID function to generate simpler expression in common cases -->
<!-- DAX MID(<string>, 0, <number>) raises error but Hana returns MID(<string>, 1, <number>) -->
<!-- DAX MID(<string>, <negative number>, <negative number>) raises error but Hana returns '' -->
<xsl:when test="name()='OpMID'">SUBSTRING(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>, <xsl:value-of select="$Op3"/>)</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="OpSUBSTITUTE">
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, '')</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op3">
<xsl:choose>
<xsl:when test="@Op3Nullable = 'false'"><xsl:apply-templates select="./*[3]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[3]"/>, '')</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="name()='OpSUBSTITUTE'">REPLACE(<xsl:apply-templates select="./*[1]"/>, <xsl:value-of select="$Op2"/>, <xsl:value-of select="$Op3"/>)</xsl:when>
</xsl:choose>
</xsl:template>

<xsl:template match="OpSEARCH|OpPATTERNSEARCH|OpFIND">
<!-- LOCATE('', '') returns NULL, should wrap with COALESCE but intentionally keep expression simple here -->
<!-- LOCATE(*, *, NULL) returns NULL, DAX SEARCH(*, *, BLANK(), *) raises error -->
<!-- LOCATE(*, *, <negative number>) searches from the end, DAX SEARCH(*, *, <negative number>, *) raises error -->

<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, '')</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, '')</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="name()='OpSEARCH' or name()='OpPATTERNSEARCH'">
<xsl:choose>
<xsl:when test="./Parameter[1] or ./InlineParameter[1]">
<xsl:choose>
<xsl:when test="name()='OpSEARCH'">
<xsl:choose>
<xsl:when test="@Op3Static=1 and @Op4Static=0">
LOCATE(UPPER(<xsl:value-of select="$Op2"/>), UPPER(<xsl:value-of select="$Op1"/>))
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN AuxTable.Result > 0 THEN AuxTable.Result ELSE <xsl:apply-templates select="./*[4]"/> END
FROM (SELECT LOCATE(UPPER(<xsl:value-of select="$Op2"/>), UPPER(<xsl:value-of select="$Op1"/>), <xsl:apply-templates select="./*[3]"/>) AS Result FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="name()='OpPATTERNSEARCH'">
<xsl:choose>
<xsl:when test="@Op3Static=1 and @Op4Static=0">
LOCATE_REGEXPR(<xsl:value-of select="$Op1"/> FLAG 'i' IN <xsl:value-of select="$Op2"/> FROM <xsl:apply-templates select="./*[3]"/>)
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN AuxTable.Result > 0 THEN AuxTable.Result ELSE <xsl:apply-templates select="./*[4]"/> END
FROM (SELECT LOCATE_REGEXPR(<xsl:value-of select="$Op1"/> FLAG 'i' IN <xsl:value-of select="$Op2"/> FROM <xsl:apply-templates select="./*[3]"/>) AS Result FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:message terminate="yes">Cartridge error: The first parameter of OpSEARCH/OpPATTERNSEARCH is expected to be a constant string.</xsl:message>
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:when test="name()='OpFIND'">
<xsl:choose>
<xsl:when test="@Op3Static=1 and @Op4Static=0">
LOCATE(<xsl:value-of select="$Op2"/>, <xsl:value-of select="$Op1"/>)
</xsl:when>
<xsl:otherwise>
(SELECT CASE WHEN AuxTable.Result > 0 THEN AuxTable.Result ELSE <xsl:apply-templates select="./*[4]"/> END
FROM (SELECT LOCATE(<xsl:value-of select="$Op2"/>, <xsl:value-of select="$Op1"/>, <xsl:apply-templates select="./*[3]"/>) AS Result FROM DUMMY) AS AuxTable)
</xsl:otherwise>
</xsl:choose>
</xsl:when>
</xsl:choose>
</xsl:template>
<xsl:template match="OpBITAND">
BITAND(<xsl:apply-templates select="./*[1]"/>, <xsl:apply-templates select="./*[2]"/>)
</xsl:template>
<xsl:template match="OpBITOR|OpBITXOR">
<xsl:variable name="Op1">
<xsl:choose>
<xsl:when test="@Op1Nullable = 'false'"><xsl:apply-templates select="./*[1]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[1]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="Op2">
<xsl:choose>
<xsl:when test="@Op2Nullable = 'false'"><xsl:apply-templates select="./*[2]"/></xsl:when>
<xsl:otherwise>COALESCE(<xsl:apply-templates select="./*[2]"/>, 0)</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="name()='OpBITOR'">BITOR(<xsl:value-of select="$Op1"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
<xsl:when test="name()='OpBITXOR'">BITXOR(<xsl:value-of select="$Op1"/>, <xsl:value-of select="$Op2"/>)</xsl:when>
</xsl:choose>
</xsl:template>
</xsl:stylesheet>
