/*
 * Generated using https://github.com/Microsoft/bond
*/
package com.microsoft.odsp.mobile;

import com.microsoft.odsp.mobile.MobileEnums.*;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;

/**
 * GENERATED Data contract class TelemetryEvent.
 *
 * "The base type of all ODSP Mobile Telemetry events"
 */
public class TelemetryEvent extends AbstractBaseEvent
{
    private TelemetryEventType eventType = TelemetryEventType.Other;
    
    private String name;
    
    private String eventSchemaVersion = "20";
    
    private BuildType buildType;
    
    private int sampleRate = 1;
    
    private NetworkType network;
    
    private String userAgent;
    
    private Integer isIntentional = 0;
    
    private String scenario;
    
    private PrivacyTagType privacyTag;
    
    private PrivacyDataType privacyDataType;
    
    private Map<String, String> additionalProperties;
    
    /**
     * Creates a new instance of the TelemetryEvent class.
     *
     * @param buildType    App build type
     * @param privacyTag    Privacy tag as defined by Office Privacy Framework guidelines. Note: not logged in telemetry.
     * @param privacyDataType    Privacy data type defined by telemetry loggers per MOJ Privacy requirements. Note: not logged in telemetry.
     */
    public TelemetryEvent(
            PrivacyDataType privacyDataType,
            PrivacyTagType privacyTag,
            BuildType buildType) {
        this.InitializeFields();
        this.buildType = buildType;
        this.privacyTag = privacyTag;
        this.privacyDataType = privacyDataType;
    }
    
    /**
     * Gets the EventType property.
     */
    public TelemetryEventType getEventType() {
        return this.eventType;
    }
    
    /**
     * Gets the Name property.
     */
    public String getName() {
        return this.name;
    }
    
    /**
     * Gets the EventSchemaVersion property.
     */
    public String getEventSchemaVersion() {
        return this.eventSchemaVersion;
    }
    
    /**
     * Gets the BuildType property.
     */
    public BuildType getBuildType() {
        return this.buildType;
    }
    
    /**
     * Sets the BuildType property. "App build type"
     */
    public void setBuildType(BuildType value) {
        this.buildType = value;
    }
    
    /**
     * Gets the SampleRate property.
     */
    public int getSampleRate() {
        return this.sampleRate;
    }
    
    /**
     * Sets the SampleRate property. "Send 1 of (sampleRate) events"
     */
    public void setSampleRate(int value) {
        this.sampleRate = value;
    }
    
    /**
     * Gets the Network property.
     */
    public NetworkType getNetwork() {
        return this.network;
    }
    
    /**
     * Sets the Network property. "Available network type"
     */
    public void setNetwork(NetworkType value) {
        this.network = value;
    }
    
    /**
     * Gets the UserAgent property.
     */
    public String getUserAgent() {
        return this.userAgent;
    }
    
    /**
     * Sets the UserAgent property. "User agent, generated by the client"
     */
    public void setUserAgent(String value) {
        this.userAgent = value;
    }
    
    /**
     * Gets the IsIntentional property.
     */
    public Integer getIsIntentional() {
        return this.isIntentional;
    }
    
    /**
     * Sets the IsIntentional property. "Whether the event represents an intentional action by the user or not"
     */
    public void setIsIntentional(Integer value) {
        this.isIntentional = value;
    }
    
    /**
     * Gets the Scenario property.
     */
    public String getScenario() {
        return this.scenario;
    }
    
    /**
     * Sets the Scenario property. "String identifying the user scenario being invoked"
     */
    public void setScenario(String value) {
        this.scenario = value;
    }
    
    /**
     * Gets the PrivacyTag property.
     */
    public PrivacyTagType getPrivacyTag() {
        return this.privacyTag;
    }
    
    /**
     * Sets the PrivacyTag property. "Privacy tag as defined by Office Privacy Framework guidelines. Note: not logged in telemetry."
     */
    public void setPrivacyTag(PrivacyTagType value) {
        this.privacyTag = value;
    }
    
    /**
     * Gets the PrivacyDataType property.
     */
    public PrivacyDataType getPrivacyDataType() {
        return this.privacyDataType;
    }
    
    /**
     * Sets the PrivacyDataType property. "Privacy data type defined by telemetry loggers per MOJ Privacy requirements. Note: not logged in telemetry."
     */
    public void setPrivacyDataType(PrivacyDataType value) {
        this.privacyDataType = value;
    }
    
    /**
     * Gets the AdditionalProperties property.
     */
    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            this.additionalProperties = new LinkedHashMap<String, String>();
        }
        return this.additionalProperties;
    }
    
    /**
     * Sets the AdditionalProperties property. "Additional data to be included with the event. This should not be used as a long-term solution for additional properties if they are core to a specific event"
     */
    public void setAdditionalProperties(Map<String, String> value) {
        this.additionalProperties = value;
    }
    

    /**
     * Retrieves the properties as a Map
     */
    public Map<String, String> getProperties() {
        Map<String, String> map = new HashMap<String, String>();

        if (eventType != null) {
            map.put("EventType", eventType.name());
        }
        
        if (name != null) {
            map.put("Name", String.valueOf(this.name));
        }
        
        if (eventSchemaVersion != null) {
            map.put("EventSchemaVersion", String.valueOf(this.eventSchemaVersion));
        }
        
        if (buildType != null) {
            map.put("BuildType", buildType.name());
        }
        
        map.put("SampleRate", String.valueOf(this.sampleRate));
        
        if (network != null) {
            map.put("Network", network.name());
        }
        
        if (userAgent != null) {
            map.put("UserAgent", String.valueOf(this.userAgent));
        }
        
        if (isIntentional != null) {
            map.put("IsIntentional", String.valueOf(this.isIntentional));
        }
        
        if (scenario != null) {
            map.put("Scenario", String.valueOf(this.scenario));
        }
        
        if (additionalProperties != null) {
            for (Map.Entry<?, ?> entry : this.additionalProperties.entrySet())
                map.put( String.format("%s%s", "NS_", entry.getKey()), String.valueOf(entry.getValue()));
        }
        
        map.put( "EventName", this.eventIdentity() );

        return map;
    }


    /**
     * Returns a set with any required properties having current values set to null
     */
    public Set<String> getEmptyProperties() {
        Set<String> blankProperties = new HashSet<String>();

        if (eventType == null) {
            blankProperties.add("eventType");
        }
        if (name == null) {
            blankProperties.add("name");
        }
        if (eventSchemaVersion == null) {
            blankProperties.add("eventSchemaVersion");
        }
        if (buildType == null) {
            blankProperties.add("buildType");
        }
        if (privacyTag == null) {
            blankProperties.add("privacyTag");
        }
        if (privacyDataType == null) {
            blankProperties.add("privacyDataType");
        }
        return blankProperties;
    }


    /**
     * Retrieves the event's proper name
     */
    public String eventIdentity() {
        return String.format("%s/%s", String.valueOf(getEventType()), String.valueOf(getName()));
    }

    /**
     * Optionally initializes fields for the current context.
     */
    protected void InitializeFields() {
        
    }

    /**
     * Retrieve the backing table for this event.
     */
    public String getTableName() {
        return "other";
    }
}
