CREATE TABLE `actions` (`app_creator_id` VARCHAR , `attachment_id` VARCHAR , `attachment_original_url` VARCHAR , `attachment_preview_url` VARCHAR , `board_id` VARCHAR , `card_id` VARCHAR , `card_name` VARCHAR , `creator_id` VARCHAR , `date` VARCHAR NOT NULL , `display_phrases` VARCHAR , `id` VARCHAR , `organization_id` VARCHAR , `text` VARCHAR , `type` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `actions_app_creator_id_idx` ON `actions` ( `app_creator_id` );
CREATE INDEX `actions_board_id_idx` ON `actions` ( `board_id` );
CREATE INDEX `actions_card_id_idx` ON `actions` ( `card_id` );
CREATE INDEX `actions_creator_id_idx` ON `actions` ( `creator_id` );
CREATE TABLE `app_creators` (`icon_url` VARCHAR , `id` VARCHAR , `name` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `attachments` (`bytes` INTEGER , `attachment_preview_url` VARCHAR , `card_id` VARCHAR , `date` VARCHAR , `edge_color` VARCHAR, `id` VARCHAR , `isUpload` SMALLINT , `attachment_max_height` INTEGER , `attachment_max_width` INTEGER, `member_id` VARCHAR , `mime_type` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `url` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `attachments_card_id_idx` ON `attachments` ( `card_id` );
CREATE TABLE `available_power_up` (`id` VARCHAR , `name` VARCHAR, `manifest_url` VARCHAR, `public` SMALLINT, PRIMARY KEY (`id`) );
CREATE TABLE `boards` (`boardstar_id` VARCHAR , `boardstar_pos` DOUBLE PRECISION , `closed` SMALLINT , `date_last_activity` VARCHAR , `date_last_view` VARCHAR , `description` VARCHAR , `id` VARCHAR , `idEnterprise` VARCHAR , `name` VARCHAR , `organization_id` VARCHAR , `prefs` VARCHAR , `premium_features` VARCHAR , `short_link` VARCHAR , `structure` VARCHAR , `subscribed` SMALLINT ,  `template_gallery` VARCHAR , `url` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `card_lists` (`board_id` VARCHAR , `closed` SMALLINT , `id` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `subscribed` SMALLINT , `soft_limit` INTEGER , `color` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `card_lists_board_id_idx` ON `card_lists` ( `board_id` );
CREATE TABLE `cards` (`address` VARCHAR , `badge_attachment_count` INTEGER , `badge_checkitem_count` INTEGER , `badge_checkitems_checked` INTEGER , `badge_checkitems_earliest_due` VARCHAR , `badge_comments` INTEGER , `badge_count` INTEGER , `badge_description` SMALLINT , `badge_location` SMALLINT , `badge_subscribed` SMALLINT , `badge_trello_attachment_count` INTEGER , `badge_viewing_member_voted` SMALLINT , `badge_votes` INTEGER , `board_id` VARCHAR , `card_cover_id` VARCHAR , `card_cover_url` VARCHAR , `card_role` VARCHAR , `closed` SMALLINT , `collapsed_attachments` INTEGER NOT NULL DEFAULT 0 , `date_last_activity` VARCHAR , `description` VARCHAR , `due_complete` SMALLINT , `due_date` VARCHAR , `due_reminder` INTEGER , `id` VARCHAR , `is_current_member_on_card` SMALLINT DEFAULT 0 , `is_template` SMALLINT DEFAULT 0 , `label_ids` VARCHAR , `latitude` DOUBLE PRECISION , `list_id` VARCHAR , `location_name` VARCHAR , `longitude` DOUBLE PRECISION , `manual_cover_attachment` SMALLINT , `member_ids` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `short_url` VARCHAR , `start_date` VARCHAR , `url` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `cards_board_id_idx` ON `cards` ( `board_id` );
CREATE INDEX `cards_closed_idx` ON `cards` ( `closed` );
CREATE INDEX `cards_is_current_member_on_card_idx` ON `cards` ( `is_current_member_on_card` );
CREATE INDEX `cards_list_id_idx` ON `cards` ( `list_id` );
CREATE TABLE `checkitems` (`card_id` VARCHAR NOT NULL , `checked` SMALLINT , `checklist_id` VARCHAR NOT NULL , `due_date` VARCHAR , `id` VARCHAR , `member_id` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , PRIMARY KEY (`id`) );
CREATE INDEX `checkitems_card_id_idx` ON `checkitems` ( `card_id` );
CREATE INDEX `checkitems_checklist_id_idx` ON `checkitems` ( `checklist_id` );
CREATE TABLE `checklists` (`card_id` VARCHAR , `board_id` VARCHAR DEFAULT '' , `collapsed` SMALLINT , `id` VARCHAR ,`name` VARCHAR , `position` DOUBLE PRECISION , `display_checked_items` SMALLINT , PRIMARY KEY (`id`) );
CREATE INDEX `checklists_card_id_idx` ON `checklists` ( `card_id` );
CREATE TABLE `covers` (`board_id` VARCHAR , `brightness` VARCHAR , `color` VARCHAR , `edge_color` VARCHAR ,  `id` VARCHAR , `id_attachment` VARCHAR , `id_uploaded_background` VARCHAR , `scaled` VARCHAR , `card_size` VARCHAR , `shared_source_url` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `credits` (`applied` SMALLINT , `day_count` INTEGER , `id` VARCHAR , `organization_id` VARCHAR , `reward` VARCHAR , `type` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `custom_field` (`display_on_card_front` SMALLINT , `id` VARCHAR , `model_id` VARCHAR , `model_type` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `custom_field_type` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `custom_field_item` (`custom_field_id` VARCHAR , `id` VARCHAR , `model_id` VARCHAR , `model_type` VARCHAR , `value` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `custom_field_option` (`color` VARCHAR , `custom_field_id` VARCHAR , `id` VARCHAR , `model_id` VARCHAR , `position` DOUBLE PRECISION , `value` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `emoji` (`category` VARCHAR , `id` VARCHAR , `keywords` VARCHAR , `name` VARCHAR , `native` VARCHAR , `short_name` VARCHAR , `short_names` VARCHAR , `tts` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `emoji_skin_variation` (`base` VARCHAR , `id` VARCHAR , `modifier` VARCHAR , `native` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `enterprise_memberships` (`admin` SMALLINT , `deactivated` SMALLINT , `id` VARCHAR , `idEnterprise` VARCHAR , `member_id` VARCHAR , PRIMARY KEY (`id`) , UNIQUE (`idEnterprise`,`member_id`) );
CREATE TABLE `highlight_item` (`type` VARCHAR , `date` VARCHAR , `fetch_group` VARCHAR , `id` VARCHAR , `board_id` VARCHAR , `card_id` VARCHAR , `list_id` VARCHAR , `creator_id` VARCHAR , `organization_id` VARCHAR , `text` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `imageColors` (`mAccentColor` INTEGER , `mColors` VARCHAR NOT NULL , `mDarkPrimaryColor` INTEGER , `mImageUrl` VARCHAR NOT NULL , `mLightPrimaryColor` INTEGER , `mPrimaryColor` INTEGER , PRIMARY KEY (`mImageUrl`) );
CREATE TABLE `in_app_message_account_status` (`id` VARCHAR, `dismissed` INTEGER, PRIMARY KEY (`id`) );
CREATE TABLE `label` (`board_id` VARCHAR , `color_name` VARCHAR , `id` VARCHAR , `name` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `label_board_id_idx` ON `label` ( `board_id` );
CREATE TABLE `limits` (`limit_applicable_model` VARCHAR NOT NULL , `limit_container_id` VARCHAR , `limit_container_model` VARCHAR NOT NULL , `limit_disable_count` INTEGER , `id` VARCHAR , `limit_scope` VARCHAR NOT NULL , `limit_server_status` VARCHAR , `limit_warn_count` INTEGER , `limit_server_count` INTEGER, PRIMARY KEY (`id`) );
CREATE TABLE `members` (`activity_blocked` SMALLINT , `avatarUrl` VARCHAR , `bio` VARCHAR , `email` VARCHAR, `confirmed` SMALLINT , `fullName` VARCHAR , `id` VARCHAR , `idEnterprise` VARCHAR , `id_enterprises_admin` VARCHAR ,  `idPaidTeamsAdmin` VARCHAR , `initials` VARCHAR , `join_date` VARCHAR , `member_type` VARCHAR , `prefs` VARCHAR , `premium_features` VARCHAR  ,  `username` VARCHAR , `non_public_overrides` SMALLINT , `one_time_messages_dismissed` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `members_username_idx` ON `members` ( `username` );
CREATE TABLE `memberships` (`deactivated` SMALLINT , `id` VARCHAR , `member_id` VARCHAR , `member_type` VARCHAR , `membership_board_or_org_id` VARCHAR , UNIQUE( `membership_board_or_org_id` , `member_id` ) ON CONFLICT REPLACE , PRIMARY KEY (`id`) );
CREATE TABLE `notifications` (`action_id` VARCHAR , `app_creator_id` VARCHAR , `attachment_id` VARCHAR , `attachment_original_url` VARCHAR , `attachment_preview_url` VARCHAR , `board_id` VARCHAR , `card_id` VARCHAR , `card_name` VARCHAR , `creator_id` VARCHAR , `date` VARCHAR NOT NULL , `dismissed` SMALLINT , `display_phrases` VARCHAR , `due` VARCHAR , `has_viewed` SMALLINT , `id` VARCHAR , `is_reactable` SMALLINT  DEFAULT 0 , `signature` VARCHAR , `unread` SMALLINT , `organization_id` VARCHAR , `text` VARCHAR , `type` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `notifications_app_creator_id_idx` ON `notifications` ( `app_creator_id` );
CREATE INDEX `notifications_board_id_idx` ON `notifications` ( `board_id` );
CREATE INDEX `notifications_card_id_idx` ON `notifications` ( `card_id` );
CREATE INDEX `notifications_creator_id_idx` ON `notifications` ( `creator_id` );
CREATE TABLE `offline_board_sync` (`id` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `organizations` (`display_name` VARCHAR , `id` VARCHAR , `idEnterprise` VARCHAR , `logo_url` VARCHAR , `name` VARCHAR , `premium_features` VARCHAR , `visibility_restrict_enterprise` VARCHAR , `visibility_restrict_org` VARCHAR , `visibility_restrict_private` VARCHAR , `visibility_restrict_public` VARCHAR , `visibility_restrict_board_invite` VARCHAR, `creator_id` VARCHAR, `creation_method` VARCHAR , `description` VARCHAR , `website_url` VARCHAR , `type` VARCHAR , `visibility` VARCHAR , `domain_name` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `paid_accounts` (`auto_renew` SMALLINT , `id` VARCHAR , `paid_product` VARCHAR , `product_override_auto_upgrade` SMALLINT , `product_override_end_date` VARCHAR , `product_override_product` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `power_up` (`id` VARCHAR , `legacy` SMALLINT , `owner_id` VARCHAR , `power_up_meta_id` VARCHAR , `promotional` SMALLINT DEFAULT 0 , PRIMARY KEY (`id`) );
CREATE TABLE `power_ups_for_board` (`id` VARCHAR , `board_id` VARCHAR, `available_power_up_id` VARCHAR, `power_up_available_on_board` SMALLINT, PRIMARY KEY (`id`) , UNIQUE(`board_id`, `available_power_up_id`));
CREATE INDEX `power_ups_for_board_board_id_idx` ON `power_ups_for_board` ( `board_id` );
CREATE TABLE `reaction` (`emoji_id` VARCHAR , `id` VARCHAR , `member_id` VARCHAR , `model_id` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `reaction_emoji` (`id` VARCHAR , `name` VARCHAR , `native` VARCHAR , `short_name` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `recentmodel` (`id` VARCHAR , `last_accessed` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `recentmodel_last_accessed_idx` ON `recentmodel` ( `last_accessed` );
CREATE TABLE `stickers` (`board_id` VARCHAR , `card_id` VARCHAR , `id` VARCHAR , `image` VARCHAR , `url` VARCHAR , `left` DOUBLE PRECISION , `rotation` DOUBLE PRECISION , `top` DOUBLE PRECISION , `z_index` INTEGER , PRIMARY KEY (`id`) );
CREATE TABLE `syncstatus` (`id` VARCHAR , `date_last_synced` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `up_next_event_container` (`id` VARCHAR , `model_id` VARCHAR , `model_type` VARCHAR , `position` DOUBLE PRECISION , PRIMARY KEY (`id`) );
CREATE TABLE `up_next_event_item` (`dismissed` SMALLINT , `id` VARCHAR , `model_id` VARCHAR , `model_type` VARCHAR , `position` DOUBLE PRECISION , `type` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `enterprises` (`id` VARCHAR , `display_name` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `butler_buttons` (`id` VARCHAR , `close` SMALLINT DEFAULT 0 , `image` VARCHAR , `label` VARCHAR , `enabled` SMALLINT , `shared` SMALLINT , `button_type` VARCHAR , `member_owner_id` VARCHAR , `model_type` VARCHAR , `model_id` VARCHAR , `position` DOUBLE PRECISION , PRIMARY KEY (`id`));
CREATE TABLE `butler_button_overrides` (`id` VARCHAR , `button_id` VARCHAR , `board_id` VARCHAR , `member_id` VARCHAR , `enabled` SMALLINT , PRIMARY KEY (`id`));
CREATE TABLE `board_my_prefs` (`id` VARCHAR , `id_email_list` VARCHAR , `email_position` VARCHAR , `full_email` VARCHAR , PRIMARY KEY(`id`));
CREATE TABLE `enterprise_licenses` (`id` VARCHAR, `idEnterprise` VARCHAR, `enterprise_license_type` VARCHAR, PRIMARY KEY(`id`));
CREATE TABLE `plugin_data` (`id` VARCHAR, `card_id` VARCHAR, `board_id` VARCHAR, `model_id` VARCHAR, `plugin_id` VARCHAR, `scope` VARCHAR, `access` VARCHAR, `plugin_data_value` VARCHAR , PRIMARY KEY (`id`));