-- Change boards.boardstar_pos from INTEGER to DOUBLE PRECISION
--
-- Since SqLite does not support altering columns, we need to create a new table, copy the values over, delete the
-- old table, then rename the new table.
--
-- Luckily, there are no indexes or foreign keys on the boards table right now, otherwise we'd have to recreate those as
-- well.

CREATE TEMPORARY TABLE `boards_tmp` (`boardstar_id` VARCHAR , `boardstar_pos` DOUBLE PRECISION , `closed` SMALLINT , `date_last_activity` VARCHAR , `date_last_view` VARCHAR , `description` VARCHAR , `id` VARCHAR , `idEnterprise` VARCHAR , `name` VARCHAR , `organization_id` VARCHAR , `prefs` VARCHAR , `premium_features` VARCHAR , `short_link` VARCHAR , `structure` VARCHAR , `subscribed` SMALLINT , `url` VARCHAR , PRIMARY KEY (`id`) );;

INSERT INTO `boards_tmp` SELECT `boardstar_id`, `boardstar_pos`, `closed`, `date_last_activity`, `date_last_view`, `description`, `id`, `idEnterprise`, `name`, `organization_id`, `prefs`, `premium_features`, `short_link`, `structure`, `subscribed`, `url` FROM `boards`;

DROP TABLE `boards`;

CREATE TABLE `boards` (`boardstar_id` VARCHAR , `boardstar_pos` DOUBLE PRECISION , `closed` SMALLINT , `date_last_activity` VARCHAR , `date_last_view` VARCHAR , `description` VARCHAR , `id` VARCHAR , `idEnterprise` VARCHAR , `name` VARCHAR , `organization_id` VARCHAR , `prefs` VARCHAR , `premium_features` VARCHAR , `short_link` VARCHAR , `structure` VARCHAR , `subscribed` SMALLINT , `url` VARCHAR , PRIMARY KEY (`id`) );;

INSERT INTO `boards` SELECT * FROM `boards_tmp`;

DROP TABLE `boards_tmp`
