/**
 * We remove the `current_member_membership` column from `boards`
 *
 * Removing a column procedure:
 * - Rename the existing table to temp table
 * - Re-create the table as it was originally named, with appropriate column(s) removed
 * - Select rows from temp table into the newly created table
 * - remove temp table
 */

ALTER TABLE boards RENAME TO temp_boards;

CREATE TABLE `boards` (`boardstar_id` VARCHAR , `boardstar_pos` INTEGER , `closed` SMALLINT , `date_last_activity` VARCHAR , `date_last_view` VARCHAR , `id` VARCHAR , `name` VARCHAR , `organization_id` VARCHAR , `prefs` VARCHAR , `short_link` VARCHAR , `structure` VARCHAR , `subscribed` SMALLINT , `url` VARCHAR, `description` VARCHAR  , PRIMARY KEY (`id`) );

INSERT INTO boards
SELECT
 boardstar_id, boardstar_pos, closed, date_last_activity, date_last_view, id, name, organization_id, prefs, short_link, structure, subscribed, url, description
FROM
 temp_boards;

DROP TABLE temp_boards;