/*
 * We add the unique constraint to `memberships`
 *
 * Adding a unique constraint requires a new call to CREATE TABLE
 */

ALTER TABLE memberships RENAME TO temp_memberships;

CREATE TABLE `memberships` (`deactivated` SMALLINT , `id` VARCHAR , `member_id` VARCHAR , `member_type` VARCHAR , `membership_board_or_org_id` VARCHAR , UNIQUE( `membership_board_or_org_id` , `member_id` ) ON CONFLICT REPLACE , PRIMARY KEY (`id`) );

INSERT INTO memberships
SELECT
 deactivated, id, member_id, member_type, membership_board_or_org_id
FROM
 temp_memberships;

DROP TABLE temp_memberships;