/*
 * We remove the `avatarHash` column from `members`
 *
 * Removing a column procedure:
 * - Rename the existing table to temp table
 * - Re-create the table as it was originally named, with appropriate column(s) removed
 * - Select rows from temp table into the newly created table
 * - remove temp table
 */

DROP INDEX `members_username_idx`;

ALTER TABLE members RENAME TO temp_members;

CREATE TABLE `members` ( `confirmed` SMALLINT , `fullName` VARCHAR , `id` VARCHAR , `initials` VARCHAR , `prefs` VARCHAR , `premium_features` VARCHAR , `username` VARCHAR , `avatarUrl` VARCHAR , PRIMARY KEY (`id`) );

CREATE INDEX `members_username_idx` ON `members` ( `username` );

INSERT INTO members
SELECT
 confirmed, fullName, id, initials, prefs, premium_features, username, avatarUrl
FROM
 temp_members;

DROP TABLE temp_members;