/*
 * We remove the `current_member_membership` column from `organizations`
 * We remove the `organizations_current_member_membership_idx` index
 *
 * We remove the `logo_hash` column from `organizations`. This column should be gone already, but now we are recreating
 * the table, so it is a good time to make it gone for good.
 *
 * Removing a column procedure:
 * - Rename the existing table to temp table
 * - Re-create the table as it was originally named, with appropriate column(s) removed
 * - Select rows from temp table into the newly created table
 * - remove temp table
 */
DROP INDEX `organizations_current_member_membership_idx`;

ALTER TABLE organizations RENAME TO temp_organizations;

CREATE TABLE `organizations` ( `display_name` VARCHAR , `id` VARCHAR , `logo_url` VARCHAR , `name` VARCHAR , `premium_features` VARCHAR , `visibility_restrict_org` VARCHAR , `visibility_restrict_private` VARCHAR , `visibility_restrict_public` VARCHAR , PRIMARY KEY (`id`) );

INSERT INTO organizations
SELECT
 display_name, id, logo_url, name, premium_features, visibility_restrict_org, visibility_restrict_private, visibility_restrict_public
FROM
 temp_organizations;

DROP TABLE temp_organizations;