/**
 * Add reaction tables
 * - `emoji`: metadata for emojis available for reactions
 * - `emoji_skin_variation`: metadata for each emoji skin variation
 * - `reaction`: member → action → emoji relationship.
 * - `reaction_emoji`: emoji used skin reactions; shared among reactions and are part of reactions
 */
CREATE TABLE `emoji` (`id` VARCHAR , `native` VARCHAR, `short_name` VARCHAR, `short_names` VARCHAR, `name` VARCHAR, `category` VARCHAR, `keywords` VARCHAR, `tts` VARCHAR, PRIMARY KEY (`id`));
CREATE TABLE `emoji_skin_variation` (`id` VARCHAR , `base` VARCHAR, `modifier` VARCHAR, `native` VARCHAR, PRIMARY KEY (`id`));
CREATE TABLE `reaction` (`id` VARCHAR, `member_id` VARCHAR, `model_id` VARCHAR, `emoji_id` VARCHAR, PRIMARY KEY (`id`));
CREATE TABLE `reaction_emoji` (`id` VARCHAR, `native` VARCHAR, `name` VARCHAR, `short_name` VARCHAR, PRIMARY KEY (`id`));