CREATE TABLE `actions` (`attachment_id` VARCHAR , `attachment_original_url` VARCHAR , `attachment_preview_url` VARCHAR , `board_id` VARCHAR , `card_id` VARCHAR , `card_name` VARCHAR , `creator_id` VARCHAR , `date` VARCHAR NOT NULL , `display_phrases` VARCHAR , `id` VARCHAR , `organization_id` VARCHAR , `text` VARCHAR , `type` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `actions_board_id_idx` ON `actions` ( `board_id` );
CREATE INDEX `actions_card_id_idx` ON `actions` ( `card_id` );
CREATE INDEX `actions_creator_id_idx` ON `actions` ( `creator_id` );
CREATE TABLE `attachments` (`bytes` INTEGER , `attachment_preview_url` VARCHAR , `card_id` VARCHAR , `date` VARCHAR , `id` VARCHAR , `isUpload` SMALLINT , `attachment_max_height` INTEGER , `attachment_max_width` INTEGER , `member_id` VARCHAR , `mime_type` VARCHAR , `name` VARCHAR , `url` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `attachments_card_id_idx` ON `attachments` ( `card_id` );
CREATE TABLE `boards` (`boardstar_id` VARCHAR , `boardstar_pos` INTEGER , `closed` SMALLINT , `current_member_membership` INTEGER , `date_last_activity` VARCHAR , `date_last_view` VARCHAR , `id` VARCHAR , `name` VARCHAR , `organization_id` VARCHAR , `prefs` VARCHAR , `short_link` VARCHAR , `subscribed` SMALLINT , `url` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `card_lists` (`board_id` VARCHAR , `closed` SMALLINT , `id` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `subscribed` SMALLINT , PRIMARY KEY (`id`) );
CREATE INDEX `card_lists_board_id_idx` ON `card_lists` ( `board_id` );
CREATE TABLE `cards` (`badge_attachment_count` INTEGER , `badge_checkitem_count` INTEGER , `badge_checkitems_checked` INTEGER , `badge_comments` INTEGER , `badge_count` INTEGER , `badge_description` SMALLINT , `badge_subscribed` SMALLINT , `badge_viewing_member_voted` SMALLINT , `badge_votes` INTEGER , `board_id` VARCHAR , `card_cover_id` VARCHAR , `card_cover_url` VARCHAR , `closed` SMALLINT , `date_last_activity` VARCHAR , `description` VARCHAR , `due_date` VARCHAR , `id` VARCHAR , `is_current_member_on_card` SMALLINT DEFAULT 0 , `label_ids` VARCHAR , `list_id` VARCHAR , `manual_cover_attachment` SMALLINT , `member_ids` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `url` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `cards_board_id_idx` ON `cards` ( `board_id` );
CREATE INDEX `cards_closed_idx` ON `cards` ( `closed` );
CREATE INDEX `cards_is_current_member_on_card_idx` ON `cards` ( `is_current_member_on_card` );
CREATE INDEX `cards_list_id_idx` ON `cards` ( `list_id` );
CREATE TABLE `checkitems` (`card_id` VARCHAR NOT NULL , `checked` SMALLINT , `checklist_id` VARCHAR NOT NULL , `id` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , PRIMARY KEY (`id`) );
CREATE INDEX `checkitems_card_id_idx` ON `checkitems` ( `card_id` );
CREATE INDEX `checkitems_checklist_id_idx` ON `checkitems` ( `checklist_id` );
CREATE TABLE `checklists` (`card_id` VARCHAR , `collapsed` SMALLINT , `id` VARCHAR , `name` VARCHAR , `position` DOUBLE PRECISION , `display_checked_items` SMALLINT , PRIMARY KEY (`id`) );
CREATE INDEX `checklists_card_id_idx` ON `checklists` ( `card_id` );
CREATE TABLE `imageColors` (`mAccentColor` INTEGER , `mColors` VARCHAR NOT NULL , `mDarkPrimaryColor` INTEGER , `mImageUrl` VARCHAR NOT NULL , `mLightPrimaryColor` INTEGER , `mPrimaryColor` INTEGER , PRIMARY KEY (`mImageUrl`) );
CREATE TABLE `label` (`board_id` VARCHAR , `color_name` VARCHAR , `id` VARCHAR , `name` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `label_board_id_idx` ON `label` ( `board_id` );
CREATE TABLE `members` (`avatarHash` VARCHAR , `confirmed` SMALLINT , `fullName` VARCHAR , `id` VARCHAR , `initials` VARCHAR , `prefs` VARCHAR , `premium_features` VARCHAR , `username` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `members_username_idx` ON `members` ( `username` );
CREATE TABLE `memberships` (`deactivated` SMALLINT , `id` VARCHAR , `member_id` VARCHAR , `member_type` VARCHAR , `membership_board_or_org_id` VARCHAR , PRIMARY KEY (`id`) );
CREATE TABLE `notifications` (`due` VARCHAR , `unread` SMALLINT , `attachment_id` VARCHAR , `attachment_original_url` VARCHAR , `attachment_preview_url` VARCHAR , `board_id` VARCHAR , `card_id` VARCHAR , `card_name` VARCHAR , `creator_id` VARCHAR , `date` VARCHAR NOT NULL , `display_phrases` VARCHAR , `id` VARCHAR , `organization_id` VARCHAR , `text` VARCHAR , `type` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `notifications_board_id_idx` ON `notifications` ( `board_id` );
CREATE INDEX `notifications_card_id_idx` ON `notifications` ( `card_id` );
CREATE INDEX `notifications_creator_id_idx` ON `notifications` ( `creator_id` );
CREATE TABLE `organizations` (`current_member_membership` VARCHAR , `display_name` VARCHAR , `id` VARCHAR , `logo_hash` VARCHAR , `name` VARCHAR , `premium_features` VARCHAR , `visibility_restrict_org` VARCHAR , `visibility_restrict_private` VARCHAR , `visibility_restrict_public` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `organizations_current_member_membership_idx` ON `organizations` ( `current_member_membership` );
CREATE TABLE `recentmodel` (`id` VARCHAR , `last_accessed` VARCHAR , PRIMARY KEY (`id`) );
CREATE INDEX `recentmodel_last_accessed_idx` ON `recentmodel` ( `last_accessed` );
CREATE TABLE `syncstatus` (`id` VARCHAR , `date_last_synced` VARCHAR , PRIMARY KEY (`id`) );