/*
 * Replace the existing download table with a new download table that moves away from model_id and model_type in
 * favor of sync_unit_id and sync_unit
 */
DROP TABLE download;

CREATE TABLE download (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* The ID of the  sync_unit e.g. boardId, cardId */
    sync_unit_id TEXT NULL,

    /* The type of the model (card, board, etc.) */
    sync_unit TEXT NOT NULL,

    /* Unique on sync_unit_id and sync_unit */
    UNIQUE (sync_unit_id, sync_unit) ON CONFLICT IGNORE
);
