/*
 * Switch identifiers table to use TEXT instead of STRING for column type.
 *
 * Using STRING means that, if the string being inserted is all numbers,
 * it uses a numeric type instead of the plain old text (I know, wtf).
 * TEXT will always insert as the text as desired.
 *
 * Since we have not shipped sync to anyone yet, we also delete any tables
 * that were related to the identifiers.
 */

DROP TABLE IF EXISTS identifiers;

DELETE FROM delta;
DELETE FROM change;
DELETE FROM download_priority;
DELETE FROM download;

CREATE TABLE identifiers (
    local_id TEXT NOT NULL PRIMARY KEY,
    server_id TEXT NOT NULL UNIQUE
);