/*
 * Added the download_priority table
 */
CREATE TABLE download_priority (
    /* The ID of this row */
    _id INTEGER  NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* The ID of the associated entry in the Download table */
    download_id INTEGER NOT NULL,

    /* Milliseconds since epoch */
    date_created INTEGER NOT NULL,

    /* This priority was created as a member of this group*/
    group_name TEXT NOT NULL,

    /* The priority for this entry */
    download_priority REAL NOT NULL,

    /* Ensure each priority references some download */
    FOREIGN KEY(download_id) REFERENCES download(_id) ON DELETE CASCADE
);