/*
 * A couple more column changes for the delta table. Just like v4, we drop tables like they are hot.
 *
 * - Rename delta.sync_id to delta.change_id, to match new name.
 * - Add ON DELETE CASCADE for the foreign key.
 */

DROP TABLE IF EXISTS delta;

CREATE TABLE delta (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Reference to the sync row this delta is part of */
    change_id INTEGER NOT NULL,

    /* The field on the model that has changed */
    model_field TEXT NOT NULL,

    /* The value that the field has been changed to */
    new_value TEXT,

    /* The original value of the field */
    original_value TEXT,

    /* Ensure each delta refers back to some change */
    FOREIGN KEY(change_id) REFERENCES change(_id) ON DELETE CASCADE
);