/*
 * A couple major changes:
 *
 * - Renamed table 'sync' to 'change', to avoid confusion.
 * - Consolidated 'is_syncing' and 'error_code' fields into a single enum, which will
 *   simplifies the model as well as properly enumerating possible states.
 *
 * SQLite does not support dropping columns. Since we have not rolled out offline changes yet,
 * dropping the table is alright for now. (We drop both to keep things consistent, otherwise
 * foreign keys could get out of hand.)
 */

DROP TABLE IF EXISTS delta;
DROP TABLE IF EXISTS sync;

CREATE TABLE change (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Milliseconds since epoch */
    date_created INTEGER NOT NULL,

    /* Enum for the type of change */
    change_type TEXT NOT NULL,

    /* The ID of the changed model */
    model_id TEXT NOT NULL,

    /* The type of the model (team, board, etc.) */
    model_type TEXT NOT NULL,

    /* The state of the change (pending, uploading, failed, etc.) */
    state TEXT NOT NULL DEFAULT 'PENDING'
);

CREATE TABLE delta (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Reference to the sync row this delta is part of */
    sync_id INTEGER NOT NULL,

    /* The field on the model that has changed */
    model_field TEXT NOT NULL,

    /* The value that the field has been changed to */
    new_value TEXT,

    /* The original value of the field */
    original_value TEXT,

    /* Ensure each delta refers back to some change */
    FOREIGN KEY(sync_id) REFERENCES change(_id)
);
