/*
 * We added the `sync` and `delta` tables for this change.
 */

CREATE TABLE sync (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Milliseconds since epoch */
    date_created INTEGER NOT NULL,

    /* Enum for the type of change */
    change_type TEXT NOT NULL,

    /* The ID of the changed model */
    model_id TEXT NOT NULL,

    /* The type of the model (team, board, etc.) */
    model_type TEXT NOT NULL,

    /* Whether this row is currently being synced with the server */
    is_syncing INTEGER NOT NULL DEFAULT 0,

    /* If an error occurred during sync, this enumerates it */
    error_code INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE delta (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Reference to the sync row this delta is part of */
    sync_id INTEGER NOT NULL,

    /* The field on the model that has changed */
    model_field TEXT NOT NULL,

    /* The value that the field has been changed to */
    new_value TEXT,

    /* The original value of the field */
    original_value TEXT,

    /* Ensure each delta refers back to some change */
    FOREIGN KEY(sync_id) REFERENCES sync(_id)
);
