/*
 * Removes the SyncUnit.NPS_NEXT_SURVEY_DATE enum from the download and download_priority tables
 * Removes the SyncUnit.NPS_CANCELED enum from the download and download_priority tables
 * download_priority has a cascading delete foreign key so it gets deleted automatically
 */
DELETE FROM download WHERE sync_unit IN ( 'NPS_NEXT_SURVEY_DATE' , 'NPS_CANCELED' );

/*
 * Removes the SyncUnit.NPS_NEXT_SURVEY_DATE enum from the sync_unit_state table
 * Removes the SyncUnit.NPS_CANCELED enum from the sync_unit_state table
 */
DELETE FROM sync_unit_state WHERE sync_unit IN ( 'NPS_NEXT_SURVEY_DATE' , 'NPS_CANCELED' );

/*
 * Removes the Model.NPS_SURVEY enum from the change and delta tables
 * delta has a cascading delete foreign key so it gets deleted automatically
 */
DELETE FROM change WHERE model_type = 'NPS_SURVEY';

/*
 * Removes the  Model.NPS_SURVEY enum from the trello_link table (WHERE IT SHOULD NEVER BE)
 */
DELETE FROM trello_link WHERE model_type = 'NPS_SURVEY';

/*
 * Removes the ModelField.PAGE_ID, ModelField.SURVEY_RATING, ModelField.SURVEY_COMPLETED, ModelField.SURVEY_COMMENT, ModelField.SURVEY_ROLE
 * enums from the delta table - these should already be cleared out since they should only apply to NPS_SURVEY types but
 * better safe than sorry
 */
DELETE FROM delta WHERE model_field IN ( 'PAGE_ID' , 'SURVEY_RATING' , 'SURVEY_COMPLETED' , 'SURVEY_COMMENT' , 'SURVEY_ROLE' );