/*
 * Removes the short_link table
 */
DROP TABLE short_link;

/*
 * Creates the trello_link table mapping trello links to local ids and model types
 */
CREATE TABLE trello_link (

    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* The trello link - should be a valid trello url */
    trello_link TEXT NOT NULL,

    /* The model that this trello_link points to */
    model_type TEXT NOT NULL,

    /* the local id of the model that this trello_link points to */
    local_id TEXT NOT NULL,

    /* Unique on trello_link  */
    UNIQUE (trello_link) ON CONFLICT REPLACE,

    /* Ensure each local_id refers back to some server_id */
    FOREIGN KEY(local_id) REFERENCES identifiers(local_id) ON DELETE CASCADE
);