/*
 * Creates the short_link table which maps short links (from trello urls) to localids
 */

CREATE TABLE short_link (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* The short link id from a trello url */
    short_link_id TEXT NOT NULL,

    /* The model that this short link points to */
    model_type TEXT NOT NULL,

    /* the local id of the model that this short link points to */
    local_id TEXT NOT NULL,

    /* Unique on short_link and model_type */
    UNIQUE (short_link_id, model_type) ON CONFLICT REPLACE,

    /* Ensure each local_id refers back to some server_id */
    FOREIGN KEY(local_id) REFERENCES identifiers(local_id) ON DELETE CASCADE
);
