/*
 * Create sync_unit_state_compound table
 *
 * This table represents the compound sync unit state for a given data item. This gives us a way to quickly query
 * complex data states, like a board and all of its children
 */

CREATE TABLE sync_unit_state_compound (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Which queue are we talking about here? (Upload, Download, other?) */
    sync_unit_queue TEXT NOT NULL,

    /*  What type of SyncUnit are we talking about here (Board, Card, StarredBoards, etc...) */
    sync_unit TEXT NOT NULL,

    /* The syncunit id in question - e.g. a boardId, a cardId, or possible Null */
    sync_unit_id TEXT NULL,

    /* True if this item or one of its children is queued */
    state_queued INTEGER DEFAULT 0,

    /* True if this item or one of its children is currently syncing */
    state_in_progress INTEGER DEFAULT 0,

    /* True if this item or one of its children is currently in an error state */
    state_error INTEGER DEFAULT 0,

    /* The timestamp for the last change to this row */
    last_success_time INTEGER NOT NULL,

    /* Unique on sync_unit_queue, sync_unit, and sync_unit_id */
    UNIQUE ( sync_unit_queue, sync_unit, sync_unit_id ) ON CONFLICT IGNORE
);