/*
 * Create sync_unit_state table
 */

CREATE TABLE sync_unit_state (
    /* The ID of this row */
    _id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,

    /* Which queue are we talking about here? (Upload, Download, other?) */
    sync_unit_queue TEXT NOT NULL,

    /*  What type of SyncUnit are we talking about here (Board, Card, StarredBoards, etc...) */
    sync_unit TEXT NOT NULL,

    /* The syncunit id in question - e.g. a boardId, a cardId, or possible Null */
    sync_unit_id TEXT NULL,

    /* Fetch the timestamp from DownloadData / UploadData tables.. */
    last_queued_time INTEGER NOT NULL,

    /* When the item was removed from the queue. */
    last_dequeue_time INTEGER NOT NULL,

    /* Update this when a sync begins */
    last_start_time INTEGER NOT NULL,

    /* Update this on success */
    last_success_time INTEGER NOT NULL,

    /* Like last_success_time, but error */
    last_error_time INTEGER NOT NULL,

    /* Unique on sync_unit_queue, sync_unit, and sync_unit_id */
    UNIQUE ( sync_unit_queue, sync_unit, sync_unit_id ) ON CONFLICT IGNORE
);